/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.logging.impl;

import java.io.IOException;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.StringSetFormatter;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="OGM")
public interface Log
extends org.hibernate.ogm.util.impl.Log {
    @Message(id=1701, value="The Hot Rod client configuration was not defined")
    public HibernateException hotrodClientConfigurationMissing();

    @Message(id=1702, value="Could not load the Hot Rod client configuration properties")
    public HibernateException failedLoadingHotRodConfigurationProperties(@Cause IOException var1);

    @Message(id=1703, value="Protobuf schema '%s' successfully deployed")
    @LogMessage(level=Logger.Level.INFO)
    public void successfulSchemaDeploy(String var1);

    @Message(id=1704, value="Error deploying Protobuf schema '%s' to the server")
    public HibernateException errorAtSchemaDeploy(String var1, @Cause Exception var2);

    @Message(id=1705, value="Generated schema: \n===========\n%s\n===========\n")
    @LogMessage(level=Logger.Level.INFO)
    public void generatedSchema(String var1);

    @Message(id=1706, value="Can not read value '%d' as a char for protobuf field '%s' as it's out of range for a Short type")
    public HibernateException truncatingShortOnRead(int var1, String var2);

    @Message(id=1707, value="Requested value for an unknown sequence on table '%s', segment '%s'")
    public HibernateException valueRequestedForUnknownSequence(String var1, String var2);

    @Message(id=1708, value="Error during parse of Protobuf schema")
    public HibernateException errorAtProtobufParsing(@Cause Exception var1);

    @Message(id=1709, value="The remote cache '%s' was expected to exist but is not defined on the server")
    public HibernateException expectedCacheNotDefined(String var1);

    @Message(id=1710, value="The remote caches '%s' were expected to exist but are not defined on the server")
    public HibernateException expectedCachesNotDefined(@FormatWith(value=StringSetFormatter.class) Set<String> var1);

    @Message(id=1711, value="This domain model would cause table '%s' to be generated without a primary key.This is not supported on an Infinispan Remote dialect: check that your embedded collections have a proper ordering definition.")
    public HibernateException tableHasNoPrimaryKey(String var1);

    @Message(id=1712, value="Sequence generator '%s' has been retrying optimistic CAS operations 10 times. This is considered high contention and has a significant performance impact; consider using a different id type, like UUID or application assigned.")
    @LogMessage(level=Logger.Level.WARN)
    public void excessiveCasForSequencer(String var1);

    @Message(id=1713, value="This thread was interrupted while in a CAS loop to generate a unique sequence number")
    public HibernateException interruptedDuringCASSequenceGeneration();

    @Message(id=1714, value="A remote read returned null while this entry was definitely initialized before. Possible data loss on the Infinispan server?")
    public HibernateException criticalDataLossDetected();

    @Message(id=1715, value="Property <%s> has to be set to <%s> but it's set to <%s>")
    public HibernateException invalidConfigurationValue(String var1, String var2, String var3);

    @Message(id=1716, value="Error deploying Protobuf schema '%s' to the server: '%s'")
    public HibernateException errorAtSchemaDeploy(String var1, String var2);
}

