/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.sequences;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.ogm.datastore.infinispanremote.impl.InfinispanRemoteDatastoreProvider;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.OgmProtoStreamMarshaller;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.SequenceTableDefinition;
import org.hibernate.ogm.datastore.infinispanremote.impl.sequences.SequencesPerCache;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.LoggerFactory;
import org.hibernate.ogm.dialect.spi.NextValueRequest;

public class HotRodSequenceHandler {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final InfinispanRemoteDatastoreProvider provider;
    private final ConcurrentMap<String, SequencesPerCache> sequencesPerCache = new ConcurrentHashMap<String, SequencesPerCache>();
    private final Map<String, SequenceTableDefinition> idSchemaPerName;
    private final OgmProtoStreamMarshaller marshaller;

    public HotRodSequenceHandler(InfinispanRemoteDatastoreProvider infinispanRemoteDatastoreProvider, OgmProtoStreamMarshaller marshaller, Map<String, SequenceTableDefinition> idSchemaPerName) {
        this.provider = infinispanRemoteDatastoreProvider;
        this.idSchemaPerName = idSchemaPerName;
        this.marshaller = marshaller;
    }

    public Number getSequenceValue(NextValueRequest request) {
        String cacheName = request.getKey().getMetadata().getName();
        SequencesPerCache sequencesSet = this.sequencesPerCache.computeIfAbsent(cacheName, k -> {
            SequenceTableDefinition sequenceTableDefinition = this.idSchemaPerName.get(cacheName);
            if (sequenceTableDefinition == null) {
                throw log.valueRequestedForUnknownSequence(request.getKey().getTable(), request.getKey().getColumnValue());
            }
            return new SequencesPerCache(this.provider, sequenceTableDefinition, this.provider.getCache(cacheName), this.marshaller);
        });
        return sequencesSet.getSequenceValue(request);
    }
}

