/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.schema;

import java.io.IOException;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.LongProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.ProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.StringProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.ProtobufEntryExporter;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.SanitationUtils;
import org.hibernate.ogm.datastore.infinispanremote.impl.sequences.SequenceId;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.infinispan.protostream.MessageMarshaller;

public final class SequenceTableDefinition
implements ProtobufEntryExporter {
    private final String messageName;
    private final String idMessageName;
    private final String keyColumnName;
    private final String valueColumnName;
    private final LongProtofieldAccessor valueEncoder;
    private final StringProtofieldAccessor sequenceNameEncoder;
    private final String protobufPackageName;

    public SequenceTableDefinition(IdSourceKeyMetadata idSourceKeyMetadata, String protobufPackageName) {
        this.protobufPackageName = protobufPackageName;
        this.messageName = SequenceTableDefinition.inferMessageName(idSourceKeyMetadata);
        this.idMessageName = SanitationUtils.toProtobufIdName(this.messageName);
        this.keyColumnName = SanitationUtils.convertNameSafely(idSourceKeyMetadata.getKeyColumnName());
        this.valueColumnName = SanitationUtils.convertNameSafely(idSourceKeyMetadata.getValueColumnName());
        this.sequenceNameEncoder = new StringProtofieldAccessor(1, this.keyColumnName, false, idSourceKeyMetadata.getKeyColumnName());
        this.valueEncoder = new LongProtofieldAccessor(2, this.valueColumnName, false, idSourceKeyMetadata.getValueColumnName());
    }

    private static String inferMessageName(IdSourceKeyMetadata idSourceKeyMetadata) {
        return SanitationUtils.convertNameSafely(idSourceKeyMetadata.getName());
    }

    @Override
    public void exportProtobufEntry(StringBuilder sb) {
        SequenceTableDefinition.exportMessage(this.idMessageName, this.sequenceNameEncoder, sb);
        SequenceTableDefinition.exportMessage(this.messageName, this.valueEncoder, sb);
    }

    private static void exportMessage(String messageName, ProtofieldAccessor<?> encoder, StringBuilder sb) {
        sb.append("\nmessage ").append(messageName).append(" {");
        encoder.exportProtobufFieldDefinition(sb);
        sb.append("\n}\n");
    }

    public String getName() {
        return this.messageName;
    }

    public SequenceId readSequenceId(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        String read = (String)this.sequenceNameEncoder.read(reader);
        return new SequenceId(read);
    }

    public void writeSequenceId(MessageMarshaller.ProtoStreamWriter writer, SequenceId t) throws IOException {
        this.sequenceNameEncoder.writeTo(writer, t.getSegmentName());
    }

    public String getQualifiedIdMessageName() {
        return SanitationUtils.qualify(this.idMessageName, this.protobufPackageName);
    }
}

