/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.protostream;

import java.util.Arrays;
import java.util.Objects;
import org.hibernate.ogm.model.key.spi.RowKey;

public final class ProtostreamId {
    public final NamedValue[] namedValues;
    public final String[] columnNames;
    public final Object[] columnValues;

    public ProtostreamId(String[] columnNames, Object[] columnValues) {
        this.columnNames = columnNames;
        this.columnValues = columnValues;
        Objects.requireNonNull(columnNames);
        Objects.requireNonNull(columnValues);
        if (columnNames.length != columnValues.length) {
            throw new IllegalArgumentException("The size of the arrays of the two parameters is required to be the same");
        }
        this.namedValues = new NamedValue[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            this.namedValues[i] = new NamedValue(columnNames[i], columnValues[i]);
        }
    }

    public RowKey toRowKey() {
        return new RowKey(this.columnNames, this.columnValues);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.namedValues);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (ProtostreamId.class != obj.getClass()) {
            return false;
        }
        ProtostreamId other = (ProtostreamId)obj;
        return Arrays.equals(this.namedValues, other.namedValues);
    }

    public String toString() {
        return "ProtostreamId:" + Arrays.toString(this.namedValues);
    }

    public static final class NamedValue {
        public final String columnName;
        public final Object columnValue;

        public NamedValue(String columnName, Object columnValue) {
            this.columnName = Objects.requireNonNull(columnName);
            this.columnValue = columnValue;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.columnName.hashCode();
            result = 31 * result + (this.columnValue == null ? 0 : this.columnValue.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (NamedValue.class != obj.getClass()) {
                return false;
            }
            NamedValue other = (NamedValue)obj;
            if (!this.columnName.equals(other.columnName)) {
                return false;
            }
            return !(this.columnValue == null ? other.columnValue != null : !this.columnValue.equals(other.columnValue));
        }

        public String toString() {
            return this.columnName + "='" + this.columnValue + "'";
        }
    }
}

