/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.protostream;

import java.io.IOException;
import java.util.Objects;
import org.hibernate.ogm.datastore.infinispanremote.impl.AssociationCacheOperation;
import org.hibernate.ogm.datastore.infinispanremote.impl.CacheOperation;
import org.hibernate.ogm.datastore.infinispanremote.impl.ProtoStreamMappingAdapter;
import org.hibernate.ogm.datastore.infinispanremote.impl.ProtostreamAssociationMappingAdapter;
import org.hibernate.ogm.datastore.infinispanremote.impl.VersionedAssociation;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.MainOgmCoDec;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.OgmProtoStreamMarshaller;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtostreamAssociationPayload;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtostreamId;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtostreamPayload;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.spi.Tuple;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.SerializationContext;

public final class ProtoDataMapper
implements ProtoStreamMappingAdapter,
ProtostreamAssociationMappingAdapter {
    private final SerializationContext serContext;
    private final MainOgmCoDec delegate;
    private final OgmProtoStreamMarshaller marshaller;

    public ProtoDataMapper(MainOgmCoDec delegate, SerializationContext serContext, OgmProtoStreamMarshaller marshaller) throws DescriptorParserException, IOException {
        this.marshaller = marshaller;
        this.delegate = Objects.requireNonNull(delegate);
        this.serContext = Objects.requireNonNull(serContext);
    }

    @Override
    public ProtostreamPayload createValuePayload(Tuple tuple) {
        return this.delegate.createValuePayload(tuple);
    }

    @Override
    public ProtostreamAssociationPayload createAssociationPayload(EntityKey key, VersionedAssociation tuple, TupleContext tupleContext) {
        return this.delegate.createAssociationPayload(key, tuple, tupleContext);
    }

    @Override
    public ProtostreamId createIdPayload(String[] columnNames, Object[] columnValues) {
        return this.delegate.createIdPayload(columnNames, columnValues);
    }

    @Override
    public <T> T withinCacheEncodingContext(CacheOperation<T> function) {
        try {
            this.marshaller.setCurrentSerializationContext(this.serContext);
            T t = function.doOnCache((RemoteCache<ProtostreamId, ProtostreamPayload>)this.delegate.getLinkedCache());
            return t;
        }
        finally {
            this.marshaller.setCurrentSerializationContext(null);
        }
    }

    @Override
    public <T> T withinCacheEncodingContext(AssociationCacheOperation<T> function) {
        try {
            this.marshaller.setCurrentSerializationContext(this.serContext);
            T t = function.doOnCache((RemoteCache<ProtostreamId, ProtostreamAssociationPayload>)this.delegate.getLinkedCache());
            return t;
        }
        finally {
            this.marshaller.setCurrentSerializationContext(null);
        }
    }

    @Override
    public String convertColumnNameToFieldName(String string) {
        return this.delegate.convertColumnNameToFieldName(string);
    }

    public String toString() {
        return "ProtoDataMapper[cacheName='" + this.delegate.getLinkedCache().getName() + "']";
    }

    @Override
    public String[] listIdColumnNames() {
        return this.delegate.listIdColumnNames();
    }
}

