/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.configuration.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.OgmProtoStreamMarshaller;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.infinispanremote.schema.spi.SchemaCapture;
import org.hibernate.ogm.datastore.infinispanremote.schema.spi.SchemaOverride;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class InfinispanRemoteConfiguration {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final String HOT_ROD_ORIGINAL_PREFIX = "infinispan.client.hotrod.";
    private static String[] noPrefixProperties = new String[]{"exhaustedAction", "maxActive", "maxTotal", "maxWait", "maxIdle", "minIdle", "numTestsPerEvictionRun", "minEvictableIdleTimeMillis", "timeBetweenEvictionRunsMillis", "lifo", "testOnBorrow", "testOnReturn", "testWhileIdle"};
    private static final String[][] expectedValuesForHotRod = new String[][]{{"infinispan.client.hotrod.force_return_values", "true"}, {"infinispan.client.hotrod.marshaller", OgmProtoStreamMarshaller.class.getName()}};
    private URL configurationResource;
    private SchemaCapture schemaCaptureService;
    private SchemaOverride schemaOverrideService;
    private String schemaPackageName;
    private Properties clientProperties;
    private boolean createCachesEnabled;

    public URL getConfigurationResourceUrl() {
        return this.configurationResource;
    }

    public Properties getClientProperties() {
        return this.clientProperties;
    }

    public SchemaCapture getSchemaCaptureService() {
        return this.schemaCaptureService;
    }

    public SchemaOverride getSchemaOverrideService() {
        return this.schemaOverrideService;
    }

    public String getSchemaPackageName() {
        return this.schemaPackageName;
    }

    public boolean isCreateCachesEnabled() {
        return this.createCachesEnabled;
    }

    public void initConfiguration(Map<?, ?> configurationMap, ServiceRegistryImplementor serviceRegistry) {
        ClassLoaderService classLoaderService = (ClassLoaderService)serviceRegistry.getService(ClassLoaderService.class);
        ConfigurationPropertyReader propertyReader = new ConfigurationPropertyReader(configurationMap, classLoaderService);
        this.configurationResource = (URL)propertyReader.property("hibernate.ogm.infinispan_remote.configuration_resource_name", URL.class).getValue();
        this.clientProperties = this.getHotRodConfiguration(configurationMap, propertyReader, this.configurationResource);
        this.schemaCaptureService = (SchemaCapture)propertyReader.property("hibernate.ogm.infinispan_remote.schema_capture_service", SchemaCapture.class).instantiate().getValue();
        this.schemaOverrideService = (SchemaOverride)propertyReader.property("hibernate.ogm.infinispan_remote.schema_override_service", SchemaOverride.class).instantiate().getValue();
        this.schemaPackageName = (String)propertyReader.property("hibernate.ogm.infinispan_remote.schema_package_name", String.class).withDefault((Object)"HibernateOGMGenerated").getValue();
        this.createCachesEnabled = (Boolean)propertyReader.property("hibernate.ogm.datastore.create_database", Boolean.TYPE).withDefault((Object)false).getValue();
        log.tracef("Initializing Infinispan Hot Rod client from configuration file at '%1$s'", this.configurationResource);
    }

    private Properties getHotRodConfiguration(Map<?, ?> configurationMap, ConfigurationPropertyReader propertyReader, URL configurationResourceUrl) {
        Properties hotRodConfiguration = new Properties();
        this.loadResourceFile(configurationResourceUrl, hotRodConfiguration);
        this.setAdditionalProperties(configurationMap, propertyReader, hotRodConfiguration);
        this.setExpectedPropertiesIfNull(hotRodConfiguration);
        this.validate(hotRodConfiguration);
        return hotRodConfiguration;
    }

    private void loadResourceFile(URL configurationResourceUrl, Properties hotRodConfiguration) {
        if (configurationResourceUrl != null) {
            try (InputStream openStream = configurationResourceUrl.openStream();){
                hotRodConfiguration.load(openStream);
            }
            catch (IOException e) {
                throw log.failedLoadingHotRodConfigurationProperties(e);
            }
        }
    }

    private void setAdditionalProperties(Map<?, ?> configurationMap, ConfigurationPropertyReader propertyReader, Properties hotRodConfiguration) {
        for (Map.Entry<?, ?> property : configurationMap.entrySet()) {
            String key = (String)property.getKey();
            if (!key.startsWith("hibernate.ogm.infinispan_remote.client.")) continue;
            String hotRodProperty = key.substring("hibernate.ogm.infinispan_remote.client.".length());
            String value = (String)propertyReader.property(key, String.class).getValue();
            if (!ArrayHelper.contains((Object[])noPrefixProperties, (Object)hotRodProperty)) {
                hotRodProperty = HOT_ROD_ORIGINAL_PREFIX + hotRodProperty;
            }
            hotRodConfiguration.setProperty(hotRodProperty, value);
        }
    }

    private void setExpectedPropertiesIfNull(Properties hotRodConfiguration) {
        for (int i = 0; i < expectedValuesForHotRod.length; ++i) {
            String property = expectedValuesForHotRod[i][0];
            String expectedValue = expectedValuesForHotRod[i][1];
            if (hotRodConfiguration.containsKey(property)) continue;
            hotRodConfiguration.setProperty(property, expectedValue);
        }
    }

    private void validate(Properties hotRodConfiguration) {
        for (int i = 0; i < expectedValuesForHotRod.length; ++i) {
            String expectedValue = expectedValuesForHotRod[i][1];
            String property = expectedValuesForHotRod[i][0];
            String actualValue = this.trim(hotRodConfiguration.getProperty(property));
            if (expectedValue.equals(actualValue) || expectedValue.equalsIgnoreCase(actualValue)) continue;
            throw log.invalidConfigurationValue(property, expectedValue, actualValue);
        }
    }

    private String trim(String property) {
        if (property == null) {
            return null;
        }
        return property.trim();
    }
}

