/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hibernate.AssertionFailure;
import org.hibernate.ogm.datastore.infinispanremote.impl.InfinispanRemoteDatastoreProvider;
import org.hibernate.ogm.datastore.infinispanremote.impl.ProtoStreamMappingAdapter;
import org.hibernate.ogm.datastore.infinispanremote.impl.ProtostreamAssociationMappingAdapter;
import org.hibernate.ogm.datastore.infinispanremote.impl.VersionedTuple;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtostreamId;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtostreamPayload;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.map.impl.MapAssociationSnapshot;
import org.hibernate.ogm.datastore.map.impl.MapHelpers;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.dialect.batch.spi.GroupedChangesToEntityOperation;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateAssociationOperation;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateTupleOperation;
import org.hibernate.ogm.dialect.batch.spi.Operation;
import org.hibernate.ogm.dialect.batch.spi.RemoveAssociationOperation;
import org.hibernate.ogm.dialect.impl.AbstractGroupingByEntityDialect;
import org.hibernate.ogm.dialect.multiget.spi.MultigetGridDialect;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.DuplicateInsertPreventionStrategy;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.OperationContext;
import org.hibernate.ogm.dialect.spi.TransactionContext;
import org.hibernate.ogm.dialect.spi.TupleAlreadyExistsException;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.dialect.spi.TuplesSupplier;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKind;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationOperation;
import org.hibernate.ogm.model.spi.AssociationOperationType;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;

public class InfinispanRemoteDialect<EK, AK, ISK>
extends AbstractGroupingByEntityDialect
implements MultigetGridDialect {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final InfinispanRemoteDatastoreProvider provider;

    public InfinispanRemoteDialect(InfinispanRemoteDatastoreProvider provider) {
        this.provider = Objects.requireNonNull(provider);
    }

    public Tuple getTuple(EntityKey key, OperationContext operationContext) {
        return InfinispanRemoteDialect.getTuple(this.provider, key);
    }

    private static Tuple getTuple(InfinispanRemoteDatastoreProvider provider, EntityKey key) {
        ProtostreamId idBuffer;
        String cacheName = InfinispanRemoteDialect.cacheName(key);
        ProtoStreamMappingAdapter mapper = provider.getDataMapperForCache(cacheName);
        VersionedValue v = mapper.withinCacheEncodingContext(arg_0 -> InfinispanRemoteDialect.lambda$getTuple$0(idBuffer = mapper.createIdPayload(key.getColumnNames(), key.getColumnValues()), arg_0));
        if (v == null) {
            return null;
        }
        ProtostreamPayload payload = (ProtostreamPayload)v.getValue();
        if (payload == null) {
            return null;
        }
        long version = v.getVersion();
        VersionedTuple versionedTuple = payload.toVersionedTuple(Tuple.SnapshotType.UPDATE);
        versionedTuple.setVersion(version);
        return versionedTuple;
    }

    public Tuple createTuple(EntityKey key, OperationContext operationContext) {
        return new VersionedTuple();
    }

    protected void executeGroupedChangesToEntity(GroupedChangesToEntityOperation groupedOperation) {
        EntityKey entityKey = groupedOperation.getEntityKey();
        String cacheName = InfinispanRemoteDialect.cacheName(entityKey);
        OwningEntity owningEntity = new OwningEntity(this.provider, entityKey);
        for (Operation operation : groupedOperation.getOperations()) {
            if (operation instanceof InsertOrUpdateTupleOperation) {
                InsertOrUpdateTupleOperation insertOrUpdateTupleOperation = (InsertOrUpdateTupleOperation)operation;
                Tuple tuple = insertOrUpdateTupleOperation.getTuplePointer().getTuple();
                owningEntity.applyOperations(tuple);
                continue;
            }
            if (operation instanceof InsertOrUpdateAssociationOperation) {
                this.insertOrUpdateAssociation((InsertOrUpdateAssociationOperation)operation);
                continue;
            }
            if (operation instanceof RemoveAssociationOperation) {
                log.debugf("removeAssociation for key '%s' on cache '%s'", entityKey, cacheName);
                RemoveAssociationOperation removeAssociationOperation = (RemoveAssociationOperation)operation;
                owningEntity.removeAssociation(removeAssociationOperation);
                continue;
            }
            throw new IllegalStateException(operation.getClass().getSimpleName() + " not supported here");
        }
        owningEntity.flushOperations();
    }

    private void insertOrUpdateAssociation(InsertOrUpdateAssociationOperation insertOrUpdateAssociationOperation) {
        AssociationKey associationKey = insertOrUpdateAssociationOperation.getAssociationKey();
        Association association = insertOrUpdateAssociationOperation.getAssociation();
        AssociationContext associationContext = insertOrUpdateAssociationOperation.getContext();
        if (!InfinispanRemoteDialect.associationStoredWithinEntityEntry(associationKey, associationContext)) {
            this.insertOrUpdateAssociationMappedAsDedicatedEntries(associationKey, association, associationContext);
        }
        association.reset();
    }

    private static TuplePointer getEmbeddingEntityTuplePointer(InfinispanRemoteDatastoreProvider provider, AssociationKey key, AssociationContext associationContext) {
        TuplePointer tuplePointer = associationContext.getEntityTuplePointer();
        if (tuplePointer.getTuple() == null) {
            tuplePointer.setTuple(InfinispanRemoteDialect.getTuple(provider, key.getEntityKey()));
        }
        return tuplePointer;
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        String cacheName = InfinispanRemoteDialect.cacheName(key);
        log.debugf("removeTuple for key '%s' on cache '%s'", key, cacheName);
        ProtoStreamMappingAdapter mapper = this.provider.getDataMapperForCache(cacheName);
        ProtostreamId idBuffer = mapper.createIdPayload(key.getColumnNames(), key.getColumnValues());
        mapper.withinCacheEncodingContext(c -> (ProtostreamPayload)c.remove((Object)idBuffer));
    }

    private static String cacheName(EntityKey key) {
        return key.getTable();
    }

    private static String cacheName(AssociationKey key) {
        return key.getTable();
    }

    private static String cacheName(EntityKeyMetadata keyMetadata) {
        return keyMetadata.getTable();
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        Map<RowKey, Map<String, Object>> results = InfinispanRemoteDialect.loadRowKeysByQuery(this.provider, key);
        if (results.isEmpty()) {
            return null;
        }
        return new Association((AssociationSnapshot)new MapAssociationSnapshot(results));
    }

    private static Map<RowKey, Map<String, Object>> loadRowKeysByQuery(InfinispanRemoteDatastoreProvider provider, AssociationKey key) {
        String cacheName = InfinispanRemoteDialect.cacheName(key);
        ProtostreamAssociationMappingAdapter mapper = provider.getCollectionsDataMapper(cacheName);
        return mapper.withinCacheEncodingContext(c -> {
            QueryFactory queryFactory = Search.getQueryFactory((RemoteCache)c);
            String[] columnNames = key.getColumnNames();
            QueryBuilder qb = queryFactory.from(ProtostreamPayload.class);
            FilterConditionContext bqEnd = null;
            boolean firstIteration = true;
            for (int i = 0; i < columnNames.length; ++i) {
                String fieldName = mapper.convertColumnNameToFieldName(columnNames[i]);
                if (firstIteration) {
                    bqEnd = (FilterConditionContext)qb.having(fieldName).eq(key.getColumnValues()[i]);
                    firstIteration = false;
                    continue;
                }
                bqEnd = (FilterConditionContext)bqEnd.and().having(fieldName).eq(key.getColumnValues()[i]);
            }
            Query query = bqEnd.toBuilder().build();
            HashMap<RowKey, Map<String, Object>> resultsCollector = new HashMap<RowKey, Map<String, Object>>();
            try (CloseableIterator iterator = c.retrieveEntriesByQuery(query, null, 100);){
                while (iterator.hasNext()) {
                    Map.Entry e = (Map.Entry)iterator.next();
                    ProtostreamPayload value = (ProtostreamPayload)e.getValue();
                    Map<String, Object> entryObject = value.toMap();
                    RowKey entryKey = value.asRowKey(key);
                    resultsCollector.put(entryKey, entryObject);
                }
            }
            return resultsCollector;
        });
    }

    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        HashMap associationMap = new HashMap();
        return new Association((AssociationSnapshot)new MapAssociationSnapshot(associationMap));
    }

    private void insertOrUpdateAssociationMappedAsDedicatedEntries(AssociationKey key, Association association, AssociationContext associationContext) {
        String cacheName = InfinispanRemoteDialect.cacheName(key);
        ProtoStreamMappingAdapter mapper = this.provider.getDataMapperForCache(cacheName);
        log.debugf("insertOrUpdateAssociation for key '%s' on cache '%s', mapped as dedicated entries in ad-hoc table", key, cacheName);
        List operations = association.getOperations();
        for (AssociationOperation ao : operations) {
            AssociationOperationType type = ao.getType();
            RowKey rowKey = ao.getKey();
            ProtostreamId idBuffer = mapper.createIdPayload(rowKey.getColumnNames(), rowKey.getColumnValues());
            switch (type) {
                case PUT: {
                    ProtostreamPayload valuePayloadForPut = mapper.createValuePayload(ao.getValue());
                    mapper.withinCacheEncodingContext(c -> (ProtostreamPayload)c.put((Object)idBuffer, (Object)valuePayloadForPut));
                    break;
                }
                case REMOVE: {
                    mapper.withinCacheEncodingContext(c -> (ProtostreamPayload)c.remove((Object)idBuffer));
                    break;
                }
                case CLEAR: {
                    throw new AssertionFailure("Request for CLEAR operation on an association mapped to dedicated entries. Makes no sense?");
                }
            }
        }
    }

    private static void removeAssociationFromBridgeTable(InfinispanRemoteDatastoreProvider provider, AssociationKey key) {
        String bridgeTable = InfinispanRemoteDialect.cacheName(key);
        ProtoStreamMappingAdapter mapper = provider.getDataMapperForCache(bridgeTable);
        Map<RowKey, Map<String, Object>> rowsMap = InfinispanRemoteDialect.loadRowKeysByQuery(provider, key);
        for (RowKey rowKey : rowsMap.keySet()) {
            String[] columnNames = rowKey.getColumnNames();
            Object[] columnValues = rowKey.getColumnValues();
            ProtostreamId idBuffer = mapper.createIdPayload(columnNames, columnValues);
            mapper.withinCacheEncodingContext(c -> (ProtostreamPayload)c.remove((Object)idBuffer));
        }
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata associationKeyMetadata, AssociationTypeContext associationTypeContext) {
        return false;
    }

    public Number nextValue(NextValueRequest request) {
        return this.provider.getSequenceHandler().getSequenceValue(request);
    }

    public void forEachTuple(ModelConsumer consumer, TupleTypeContext tupleTypeContext, EntityKeyMetadata entityKeyMetadata) {
        String cacheName = InfinispanRemoteDialect.cacheName(entityKeyMetadata);
        ProtoStreamMappingAdapter mapper = this.provider.getDataMapperForCache(cacheName);
        VersionedValue v = mapper.withinCacheEncodingContext(c -> {
            consumer.consume((TuplesSupplier)new InfinispanRemoteTuplesSupplier((RemoteCache<ProtostreamId, ProtostreamPayload>)c, cacheName));
            return null;
        });
    }

    public DuplicateInsertPreventionStrategy getDuplicateInsertPreventionStrategy(EntityKeyMetadata entityKeyMetadata) {
        return DuplicateInsertPreventionStrategy.LOOK_UP;
    }

    public boolean supportsSequences() {
        return false;
    }

    public List<Tuple> getTuples(EntityKey[] keys, TupleContext tupleContext) {
        Objects.requireNonNull(keys);
        if (keys.length == 0) {
            return Collections.emptyList();
        }
        if (keys.length == 1) {
            return Collections.singletonList(this.getTuple(keys[0], (OperationContext)tupleContext));
        }
        String cacheName = InfinispanRemoteDialect.cacheName(keys[0]);
        ProtoStreamMappingAdapter mapper = this.provider.getDataMapperForCache(cacheName);
        HashMap<EntityKey, ProtostreamId> keyConversionMatch = new HashMap<EntityKey, ProtostreamId>();
        HashSet<ProtostreamId> convertedKeys = new HashSet<ProtostreamId>();
        for (EntityKey ek : keys) {
            if (ek == null) continue;
            assert (InfinispanRemoteDialect.cacheName(ek).equals(cacheName)) : "The javadoc comment promised batches would be loaded from the same table";
            ProtostreamId idBuffer = mapper.createIdPayload(ek.getColumnNames(), ek.getColumnValues());
            keyConversionMatch.put(ek, idBuffer);
            convertedKeys.add(idBuffer);
        }
        Map loadedBulk = mapper.withinCacheEncodingContext(c -> c.getAll(convertedKeys));
        ArrayList<Tuple> results = new ArrayList<Tuple>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            EntityKey originalKey = keys[i];
            if (originalKey == null) {
                results.add(null);
                continue;
            }
            ProtostreamId protostreamId = (ProtostreamId)keyConversionMatch.get(originalKey);
            ProtostreamPayload payload = (ProtostreamPayload)loadedBulk.get(protostreamId);
            if (payload == null) {
                results.add(null);
                continue;
            }
            results.add(payload.toTuple(Tuple.SnapshotType.UNKNOWN));
        }
        return results;
    }

    private static boolean associationStoredWithinEntityEntry(AssociationKey key, AssociationContext associationContext) {
        String entityTableName;
        String cacheName = InfinispanRemoteDialect.cacheName(key);
        return cacheName.equals(entityTableName = associationContext.getAssociationTypeContext().getAssociatedEntityKeyMetadata().getEntityKeyMetadata().getTable()) && !key.getMetadata().getAssociationKind().equals((Object)AssociationKind.EMBEDDED_COLLECTION);
    }

    private static /* synthetic */ VersionedValue lambda$getTuple$0(ProtostreamId idBuffer, RemoteCache c) {
        return c.getVersioned((Object)idBuffer);
    }

    private static class InfinispanRemoteTupleIterator
    implements ClosableIterator<Tuple> {
        private final CloseableIterator<Map.Entry<Object, MetadataValue<Object>>> iterator;

        public InfinispanRemoteTupleIterator(CloseableIterator<Map.Entry<Object, MetadataValue<Object>>> iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Tuple next() {
            Map.Entry next = (Map.Entry)this.iterator.next();
            VersionedTuple tuple = this.createTuple(next);
            return tuple;
        }

        private VersionedTuple createTuple(Map.Entry<Object, MetadataValue<Object>> next) {
            ProtostreamPayload obj = (ProtostreamPayload)next.getValue().getValue();
            long version = next.getValue().getVersion();
            VersionedTuple tuple = obj.toVersionedTuple(Tuple.SnapshotType.UPDATE);
            tuple.setVersion(version);
            return tuple;
        }

        public void close() {
            this.iterator.close();
        }
    }

    private static class InfinispanRemoteTuplesSupplier
    implements TuplesSupplier {
        private final RemoteCache<ProtostreamId, ProtostreamPayload> remoteCache;

        public InfinispanRemoteTuplesSupplier(RemoteCache<ProtostreamId, ProtostreamPayload> remoteCache, String cacheName) {
            this.remoteCache = remoteCache;
        }

        public ClosableIterator<Tuple> get(TransactionContext transactionContext) {
            CloseableIterator iterator = this.remoteCache.retrieveEntriesWithMetadata(null, 100);
            return new InfinispanRemoteTupleIterator((CloseableIterator<Map.Entry<Object, MetadataValue<Object>>>)iterator);
        }
    }

    private static class OwningEntity {
        private final InfinispanRemoteDatastoreProvider provider;
        private final List<AssociationKey> associationsToRemove = new ArrayList<AssociationKey>();
        private final EntityKey ownerEntityKey;
        private Map<String, Object> owningEntity;
        private Tuple.SnapshotType operationType = Tuple.SnapshotType.UPDATE;

        public OwningEntity(InfinispanRemoteDatastoreProvider provider, EntityKey entityKey) {
            this.provider = provider;
            this.ownerEntityKey = entityKey;
        }

        public void flushOperations() {
            if (!this.associationsToRemove.isEmpty()) {
                for (AssociationKey key : this.associationsToRemove) {
                    InfinispanRemoteDialect.removeAssociationFromBridgeTable(this.provider, key);
                }
            }
            if (this.owningEntity != null) {
                this.flushEntity();
            }
        }

        private void flushEntity() {
            Tuple versionedTuple = new Tuple((TupleSnapshot)new MapTupleSnapshot(this.owningEntity), this.operationType);
            ProtoStreamMappingAdapter mapper = this.provider.getDataMapperForCache(InfinispanRemoteDialect.cacheName(this.ownerEntityKey));
            ProtostreamId idBuffer = mapper.createIdPayload(this.ownerEntityKey.getColumnNames(), this.ownerEntityKey.getColumnValues());
            ProtostreamPayload valuePayload = mapper.createValuePayload(versionedTuple);
            if (this.operationType == Tuple.SnapshotType.INSERT) {
                this.insertEntity(mapper, idBuffer, valuePayload);
            } else {
                this.updateEntity(mapper, idBuffer, valuePayload);
            }
        }

        private void updateEntity(ProtoStreamMappingAdapter mapper, ProtostreamId idBuffer, ProtostreamPayload valuePayload) {
            mapper.withinCacheEncodingContext(c -> (ProtostreamPayload)c.put((Object)idBuffer, (Object)valuePayload));
        }

        private void insertEntity(ProtoStreamMappingAdapter mapper, ProtostreamId idBuffer, ProtostreamPayload valuePayload) {
            boolean optimisticLockError;
            ProtostreamPayload result = mapper.withinCacheEncodingContext(c -> (ProtostreamPayload)c.putIfAbsent((Object)idBuffer, (Object)valuePayload));
            boolean bl = optimisticLockError = null != result;
            if (optimisticLockError) {
                throw new TupleAlreadyExistsException(this.ownerEntityKey);
            }
        }

        public void removeAssociation(RemoveAssociationOperation removeAssociationOperation) {
            AssociationContext associationContext;
            AssociationKey associationKey = removeAssociationOperation.getAssociationKey();
            if (InfinispanRemoteDialect.associationStoredWithinEntityEntry(associationKey, associationContext = removeAssociationOperation.getContext())) {
                if (this.owningEntity == null) {
                    TuplePointer entityTuplePointer = InfinispanRemoteDialect.getEmbeddingEntityTuplePointer(this.provider, associationKey, associationContext);
                    entityTuplePointer.getTuple().setSnapshotType(Tuple.SnapshotType.UPDATE);
                    this.applyOperations(entityTuplePointer.getTuple());
                }
            } else {
                this.associationsToRemove.add(associationKey);
            }
        }

        public void applyOperations(Tuple tuple) {
            if (this.owningEntity == null) {
                this.owningEntity = this.getEntityFromTuple(this.owningEntity, tuple);
            }
            if (tuple.getSnapshotType() == Tuple.SnapshotType.INSERT) {
                this.operationType = Tuple.SnapshotType.INSERT;
            }
            MapHelpers.applyTupleOpsOnMap((Tuple)tuple, this.owningEntity);
        }

        private Map<String, Object> getEntityFromTuple(Map<String, Object> owningEntity, Tuple tuple) {
            if (tuple != null) {
                if (owningEntity == null) {
                    owningEntity = new HashMap<String, Object>();
                }
                for (String column : tuple.getColumnNames()) {
                    owningEntity.put(column, tuple.get(column));
                }
            }
            return owningEntity;
        }
    }
}

