/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.storage;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.FailureStorage;
import org.neo4j.kernel.api.impl.index.storage.layout.FolderLayout;
import org.neo4j.kernel.api.impl.index.storage.layout.IndexFolderLayout;
import org.neo4j.kernel.impl.util.NumberAwareStringComparator;

public class PartitionedIndexStorage {
    private static final Comparator<File> FILE_COMPARATOR = (o1, o2) -> NumberAwareStringComparator.INSTANCE.compare(o1.getName(), o2.getName());
    private final DirectoryFactory directoryFactory;
    private final FileSystemAbstraction fileSystem;
    private final boolean archiveFailed;
    private final FolderLayout folderLayout;
    private final FailureStorage failureStorage;

    public PartitionedIndexStorage(DirectoryFactory directoryFactory, FileSystemAbstraction fileSystem, File rootFolder, boolean archiveFailed) {
        this.fileSystem = fileSystem;
        this.archiveFailed = archiveFailed;
        this.folderLayout = new IndexFolderLayout(rootFolder);
        this.directoryFactory = directoryFactory;
        this.failureStorage = new FailureStorage(fileSystem, this.folderLayout);
    }

    public Directory openDirectory(File folder) throws IOException {
        return this.directoryFactory.open(folder);
    }

    public File getPartitionFolder(int partition) {
        return this.folderLayout.getPartitionFolder(partition);
    }

    public File getIndexFolder() {
        return this.folderLayout.getIndexFolder();
    }

    public void reserveIndexFailureStorage() throws IOException {
        this.failureStorage.reserveForIndex();
    }

    public void storeIndexFailure(String failure) throws IOException {
        this.failureStorage.storeIndexFailure(failure);
    }

    public String getStoredIndexFailure() {
        return this.failureStorage.loadIndexFailure();
    }

    public void prepareFolder(File folder) throws IOException {
        this.cleanupFolder(folder, this.archiveFailed);
        this.fileSystem.mkdirs(folder);
    }

    public void cleanupFolder(File folder) throws IOException {
        this.cleanupFolder(folder, false);
    }

    private void cleanupFolder(File folder, boolean archiveFailed) throws IOException {
        List<File> partitionFolders = this.listFolders(folder);
        if (!partitionFolders.isEmpty()) {
            try (ZipOutputStream zip = this.archiveFile(folder, archiveFailed);){
                byte[] buffer = null;
                if (zip != null) {
                    buffer = new byte[4096];
                }
                for (File partitionFolder : partitionFolders) {
                    this.cleanupLuceneDirectory(partitionFolder, zip, buffer);
                }
            }
        }
        this.fileSystem.deleteRecursively(folder);
    }

    private ZipOutputStream archiveFile(File folder, boolean archiveFailed) throws IOException {
        ZipOutputStream zip = null;
        if (archiveFailed) {
            File archiveFile = new File(folder.getParent(), "archive-" + folder.getName() + "-" + System.currentTimeMillis() + ".zip");
            zip = new ZipOutputStream(this.fileSystem.openAsOutputStream(archiveFile, false));
        }
        return zip;
    }

    public Map<File, Directory> openIndexDirectories() throws IOException {
        LinkedHashMap<File, Directory> directories = new LinkedHashMap<File, Directory>();
        try {
            for (File dir : this.listFolders()) {
                directories.put(dir, this.directoryFactory.open(dir));
            }
        }
        catch (IOException oe) {
            try {
                IOUtils.closeAll(directories.values());
            }
            catch (Exception ce) {
                oe.addSuppressed(ce);
            }
            throw oe;
        }
        return directories;
    }

    public List<File> listFolders() {
        return this.listFolders(this.getIndexFolder());
    }

    private List<File> listFolders(File rootFolder) {
        File[] files = this.fileSystem.listFiles(rootFolder);
        return files == null ? Collections.emptyList() : Stream.of(files).filter(arg_0 -> ((FileSystemAbstraction)this.fileSystem).isDirectory(arg_0)).sorted(FILE_COMPARATOR).collect(Collectors.toList());
    }

    private void cleanupLuceneDirectory(File folder, ZipOutputStream zip, byte[] buffer) throws IOException {
        try (Directory dir = this.directoryFactory.open(folder);){
            String[] indexFiles;
            String folderName = folder.getName() + "/";
            if (zip != null) {
                zip.putNextEntry(new ZipEntry(folderName));
                zip.closeEntry();
            }
            for (String indexFile : indexFiles = dir.listAll()) {
                if (zip != null) {
                    zip.putNextEntry(new ZipEntry(folderName + indexFile));
                    try (IndexInput input = dir.openInput(indexFile, IOContext.READ);){
                        int read;
                        long size = input.length();
                        for (long pos = 0L; pos < size; pos += (long)read) {
                            read = Math.min(buffer.length, (int)(size - pos));
                            input.readBytes(buffer, 0, read);
                            zip.write(buffer, 0, read);
                        }
                    }
                    zip.closeEntry();
                }
                FileUtils.windowsSafeIOOperation(() -> dir.deleteFile(indexFile));
            }
        }
    }
}

