/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.neo4j.index.impl.lucene.explicit.IndexIdentifier;
import org.neo4j.index.impl.lucene.explicit.IndexReference;

class WritableIndexReference
extends IndexReference {
    private final IndexWriter writer;
    private boolean writerIsClosed;
    private final AtomicBoolean stale = new AtomicBoolean();

    WritableIndexReference(IndexIdentifier identifier, IndexSearcher searcher, IndexWriter writer) {
        super(identifier, searcher);
        this.writer = writer;
    }

    @Override
    public IndexWriter getWriter() {
        return this.writer;
    }

    @Override
    public synchronized void dispose() throws IOException {
        this.disposeSearcher();
        this.disposeWriter();
    }

    @Override
    public boolean checkAndClearStale() {
        return this.stale.compareAndSet(true, false);
    }

    @Override
    public void setStale() {
        this.stale.set(true);
    }

    private void disposeWriter() throws IOException {
        if (!this.writerIsClosed) {
            this.writer.close();
            this.writerIsClosed = true;
        }
    }

    boolean isWriterClosed() {
        return this.writerIsClosed;
    }
}

