/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl;

import org.bson.Document;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.NegatablePredicate;

public class MongoDBComparisonPredicate
extends ComparisonPredicate<Document>
implements NegatablePredicate<Document> {
    public MongoDBComparisonPredicate(String propertyName, ComparisonPredicate.Type comparisonType, Object value) {
        super(propertyName, comparisonType, value);
    }

    protected Document getStrictlyLessQuery() {
        return new Document(this.propertyName, (Object)new Document("$lt", this.value));
    }

    protected Document getLessOrEqualsQuery() {
        return new Document(this.propertyName, (Object)new Document("$lte", this.value));
    }

    protected Document getEqualsQuery() {
        return new Document(this.propertyName, this.value);
    }

    protected Document getGreaterOrEqualsQuery() {
        return new Document(this.propertyName, (Object)new Document("$gte", this.value));
    }

    protected Document getStrictlyGreaterQuery() {
        return new Document(this.propertyName, (Object)new Document("$gt", this.value));
    }

    public Document getNegatedQuery() {
        switch (this.type) {
            case LESS: {
                return new Document(this.propertyName, (Object)new Document("$gte", this.value));
            }
            case LESS_OR_EQUAL: {
                return new Document(this.propertyName, (Object)new Document("$gt", this.value));
            }
            case EQUALS: {
                return new Document(this.propertyName, (Object)new Document("$ne", this.value));
            }
            case GREATER_OR_EQUAL: {
                return new Document(this.propertyName, (Object)new Document("$lt", this.value));
            }
            case GREATER: {
                return new Document(this.propertyName, (Object)new Document("$lte", this.value));
            }
        }
        throw new UnsupportedOperationException("Unsupported comparison type: " + this.type);
    }
}

