/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.Document;
import org.hibernate.ogm.datastore.mongodb.query.impl.MongoDBQueryDescriptor;
import org.hibernate.ogm.query.spi.QueryParsingResult;

public class MongoDBQueryParsingResult
implements QueryParsingResult {
    private final Class<?> entityType;
    private final String collectionName;
    private final Document query;
    private final Document projection;
    private final Document orderBy;
    private final List<String> unwinds;

    public MongoDBQueryParsingResult(Class<?> entityType, String collectionName, Document query, Document projection, Document orderBy, List<String> unwinds) {
        this.entityType = entityType;
        this.collectionName = collectionName;
        this.query = query;
        this.projection = projection;
        this.orderBy = orderBy;
        this.unwinds = unwinds;
    }

    public Document getQuery() {
        return this.query;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public Document getProjection() {
        return this.projection;
    }

    public Document getOrderBy() {
        return this.orderBy;
    }

    public List<String> getUnwinds() {
        return this.unwinds;
    }

    public Object getQueryObject() {
        return new MongoDBQueryDescriptor(this.collectionName, this.unwinds == null ? MongoDBQueryDescriptor.Operation.FIND : MongoDBQueryDescriptor.Operation.AGGREGATE, this.query, this.projection, this.orderBy, null, null, null, this.unwinds, null, null, null);
    }

    public List<String> getColumnNames() {
        return this.projection != null ? new ArrayList(this.projection.keySet()) : Collections.emptyList();
    }

    public String toString() {
        return "MongoDBQueryParsingResult [entityType=" + this.entityType.getSimpleName() + ", query=" + this.query + ", projection=" + this.projection + "]";
    }
}

