/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.index.impl;

import org.hibernate.ogm.util.impl.StringHelper;

public enum MongoDBIndexType {
    NORMAL(null),
    TEXT("text"),
    TWODSPHERE("2dsphere"),
    TWOD("2d");

    private String type;

    private MongoDBIndexType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static MongoDBIndexType from(String type) {
        if (StringHelper.isEmpty((String)type)) {
            return NORMAL;
        }
        if (MongoDBIndexType.TEXT.type.equals(type)) {
            return TEXT;
        }
        if (MongoDBIndexType.TWODSPHERE.type.equals(type)) {
            return TWODSPHERE;
        }
        if (MongoDBIndexType.TWOD.type.equals(type)) {
            return TWOD;
        }
        throw new IllegalArgumentException("Unsupported MongoDB index type " + type);
    }
}

