/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.index.impl;

import com.mongodb.client.model.IndexOptions;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.ogm.datastore.mongodb.index.impl.MongoDBIndexType;

public class MongoDBIndexSpec {
    private static final String INDEX_TYPE_OPTION = "_type";
    private final String collection;
    private final String indexName;
    private final Document indexKeys = new Document();
    private final IndexOptions options;
    private final MongoDBIndexType indexType;

    public MongoDBIndexSpec(String collection, String columnName, String indexName, Document options) {
        this.indexType = MongoDBIndexSpec.determineIndexType(options);
        this.options = MongoDBIndexSpec.prepareOptions(this.indexType, options, indexName, true);
        this.collection = collection;
        this.indexName = indexName;
        this.indexKeys.put(columnName, (Object)1);
    }

    public MongoDBIndexSpec(UniqueKey uniqueKey, Document options) {
        this.indexType = MongoDBIndexSpec.determineIndexType(options);
        this.options = MongoDBIndexSpec.prepareOptions(this.indexType, options, uniqueKey.getName(), true);
        this.collection = uniqueKey.getTable().getName();
        this.indexName = uniqueKey.getName();
        this.addIndexKeys(uniqueKey.getColumnIterator(), uniqueKey.getColumnOrderMap());
    }

    public MongoDBIndexSpec(Index index, Document options) {
        this.indexType = MongoDBIndexSpec.determineIndexType(options);
        this.options = MongoDBIndexSpec.prepareOptions(this.indexType, options, index.getName(), false);
        this.collection = index.getTable().getName();
        this.indexName = index.getName();
        this.addIndexKeys(index.getColumnIterator(), Collections.emptyMap());
    }

    private static MongoDBIndexType determineIndexType(Document options) {
        MongoDBIndexType indexType = MongoDBIndexType.from(options.getString((Object)INDEX_TYPE_OPTION));
        options.remove((Object)INDEX_TYPE_OPTION);
        if (MongoDBIndexType.NORMAL.equals((Object)indexType) && Boolean.TRUE.equals(options.get((Object)"text"))) {
            options.remove((Object)"text");
            return MongoDBIndexType.TEXT;
        }
        return indexType;
    }

    private static IndexOptions prepareOptions(MongoDBIndexType indexType, Document options, String indexName, boolean unique) {
        IndexOptions indexOptions = new IndexOptions();
        indexOptions.name(indexName).unique(unique).background(options.getBoolean((Object)"background", false));
        if (unique) {
            indexOptions.sparse(!options.containsKey((Object)"partialFilterExpression"));
        } else if (options.containsKey((Object)"partialFilterExpression")) {
            indexOptions.partialFilterExpression((Bson)options.get((Object)"partialFilterExpression"));
        }
        if (options.containsKey((Object)"expireAfterSeconds")) {
            indexOptions.expireAfter(Long.valueOf(options.getInteger((Object)"expireAfterSeconds").longValue()), TimeUnit.SECONDS);
        }
        if (MongoDBIndexType.TEXT.equals((Object)indexType)) {
            if (options.containsKey((Object)"default_language")) {
                indexOptions.defaultLanguage(options.getString((Object)"default_language"));
            }
            if (options.containsKey((Object)"weights")) {
                indexOptions.weights((Bson)options.get((Object)"weights"));
            }
            options.remove((Object)"text");
        }
        return indexOptions;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public MongoDBIndexType getIndexType() {
        return this.indexType;
    }

    private void addIndexKeys(Iterator<Column> columnIterator, Map<Column, String> columnOrderMap) {
        while (columnIterator.hasNext()) {
            Object mongoDBOrder;
            Column column = columnIterator.next();
            if (MongoDBIndexType.NORMAL.equals((Object)this.indexType)) {
                String order = columnOrderMap.get(column) != null ? columnOrderMap.get(column) : "asc";
                mongoDBOrder = "asc".equals(order) ? 1 : -1;
            } else {
                mongoDBOrder = this.indexType.getType();
            }
            this.indexKeys.put(column.getName(), mongoDBOrder);
        }
    }

    public IndexOptions getOptions() {
        return this.options;
    }

    public Document getIndexKeysDocument() {
        return this.indexKeys;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append("collection: ").append(this.collection).append(", ");
        sb.append("indexName: ").append(this.indexName).append(", ");
        sb.append("indexType: ").append((Object)this.indexType);
        sb.append("]");
        return sb.toString();
    }
}

