/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.dialect.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bson.Document;
import org.hibernate.ogm.datastore.document.association.spi.AssociationRow;
import org.hibernate.ogm.datastore.document.association.spi.StructureOptimizerAssociationRowFactory;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoHelpers;

public class MongoDBAssociationRowFactory
extends StructureOptimizerAssociationRowFactory<Document> {
    public static final MongoDBAssociationRowFactory INSTANCE = new MongoDBAssociationRowFactory();

    private MongoDBAssociationRowFactory() {
        super(Document.class);
    }

    protected Document getSingleColumnRow(String columnName, Object value) {
        Document dbObjectAsRow = new Document();
        MongoHelpers.setValue(dbObjectAsRow, columnName, value);
        return dbObjectAsRow;
    }

    protected AssociationRow.AssociationRowAccessor<Document> getAssociationRowAccessor(String[] prefixedColumns, String prefix) {
        return prefix != null ? new MongoDBAssociationRowAccessor(prefixedColumns, prefix) : MongoDBAssociationRowAccessor.INSTANCE;
    }

    private static class MongoDBAssociationRowAccessor
    implements AssociationRow.AssociationRowAccessor<Document> {
        private static final MongoDBAssociationRowAccessor INSTANCE = new MongoDBAssociationRowAccessor();
        private final String prefix;
        private final List<String> prefixedColumns;

        public MongoDBAssociationRowAccessor() {
            this(null, null);
        }

        public MongoDBAssociationRowAccessor(String[] prefixedColumns, String prefix) {
            this.prefix = prefix;
            this.prefixedColumns = prefix != null ? Arrays.asList(prefixedColumns) : new ArrayList<String>(0);
        }

        public Set<String> getColumnNames(Document row) {
            HashSet<String> columnNames = new HashSet<String>();
            this.addColumnNames(row, columnNames, "");
            for (String prefixedColumn : this.prefixedColumns) {
                String unprefixedColumn = this.removePrefix(prefixedColumn);
                if (!columnNames.contains(unprefixedColumn)) continue;
                columnNames.remove(unprefixedColumn);
                columnNames.add(prefixedColumn);
            }
            return columnNames;
        }

        private String removePrefix(String prefixedColumn) {
            return prefixedColumn.substring(this.prefix.length() + 1);
        }

        private void addColumnNames(Document row, Set<String> columnNames, String prefix) {
            for (String field : row.keySet()) {
                Object sub = row.get((Object)field);
                if (sub instanceof Document) {
                    this.addColumnNames((Document)sub, columnNames, MongoHelpers.flatten(prefix, field));
                    continue;
                }
                columnNames.add(MongoHelpers.flatten(prefix, field));
            }
        }

        public Object get(Document row, String column) {
            if (this.prefixedColumns.contains(column)) {
                column = this.removePrefix(column);
            }
            return MongoHelpers.getValueOrNull(row, column);
        }
    }
}

