/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Comparator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.virtual.CoordinateReferenceSystem;
import org.neo4j.values.virtual.VirtualValueGroup;

public abstract class PointValue
extends VirtualValue {
    private double xCoordinate;
    private double yCoordinate;

    PointValue(double x, double y) {
        this.xCoordinate = x;
        this.yCoordinate = y;
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        writer.beginPoint(this.getCoordinateReferenceSystem());
        writer.writeFloatingPoint(this.xCoordinate);
        writer.writeFloatingPoint(this.yCoordinate);
        writer.endPoint();
    }

    public abstract CoordinateReferenceSystem getCoordinateReferenceSystem();

    public double[] coordinates() {
        return new double[]{this.xCoordinate, this.yCoordinate};
    }

    @Override
    public boolean equals(VirtualValue o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PointValue that = (PointValue)o;
        return this.xCoordinate == that.xCoordinate && this.yCoordinate == that.yCoordinate;
    }

    @Override
    public int computeHash() {
        int result = 0;
        result = 31 * (result + NumberValues.hash(this.xCoordinate));
        result = 31 * (result + NumberValues.hash(this.yCoordinate));
        return result;
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.POINT;
    }

    @Override
    public int compareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        if (!(other instanceof PointValue)) {
            throw new IllegalArgumentException("Cannot compare different virtual values");
        }
        PointValue otherPoint = (PointValue)other;
        int x = this.getCoordinateReferenceSystem().compareTo(otherPoint.getCoordinateReferenceSystem());
        if (x == 0 && (x = Double.compare(this.xCoordinate, otherPoint.xCoordinate)) == 0) {
            return Double.compare(this.yCoordinate, otherPoint.yCoordinate);
        }
        return x;
    }

    public String toString() {
        return String.format("Point{ %s, %.3e, %.3e}", this.getCoordinateReferenceSystem().name, this.xCoordinate, this.yCoordinate);
    }

    static class GeographicPointValue
    extends PointValue {
        GeographicPointValue(double longitude, double latitude) {
            super(longitude, latitude);
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return CoordinateReferenceSystem.WGS84;
        }
    }

    static class CartesianPointValue
    extends PointValue {
        CartesianPointValue(double x, double y) {
            super(x, y);
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return CoordinateReferenceSystem.Cartesian;
        }
    }
}

