/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx;

import org.neo4j.jmx.Description;
import org.neo4j.jmx.ManagementInterface;

@ManagementInterface(name="Store sizes")
@Description(value="Information about the disk space used by different parts of the Neo4j graph store")
public interface StoreSize {
    public static final String NAME = "Store sizes";

    @Description(value="Disk space used by the transaction logs, in bytes.")
    public long getTransactionLogsSize();

    @Description(value="Disk space used to store nodes, in bytes.")
    public long getNodeStoreSize();

    @Description(value="Disk space used to store relationships, in bytes.")
    public long getRelationshipStoreSize();

    @Description(value="Disk space used to store properties (excluding string values and array values), in bytes.")
    public long getPropertyStoreSize();

    @Description(value="Disk space used to store string properties, in bytes.")
    public long getStringStoreSize();

    @Description(value="Disk space used to store array properties, in bytes.")
    public long getArrayStoreSize();

    @Description(value="Disk space used to store labels, in bytes")
    public long getLabelStoreSize();

    @Description(value="Disk space used to store counters, in bytes")
    public long getCountStoreSize();

    @Description(value="Disk space used to store schemas (index and constrain declarations), in bytes")
    public long getSchemaStoreSize();

    @Description(value="Disk space used to store all indices, in bytes")
    public long getIndexStoreSize();

    @Description(value="Disk space used by whole store, in bytes.")
    public long getTotalStoreSize();
}

