/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.http.transaction.impl;

import javax.transaction.Synchronization;
import org.hibernate.ogm.datastore.neo4j.remote.http.impl.HttpNeo4jClient;
import org.hibernate.ogm.datastore.neo4j.remote.http.impl.HttpNeo4jDatastoreProvider;
import org.hibernate.ogm.datastore.neo4j.remote.http.transaction.impl.HttpNeo4jTransaction;
import org.hibernate.ogm.datastore.neo4j.transaction.impl.BaseNeo4jJtaTransactionCoordinator;
import org.hibernate.ogm.datastore.neo4j.transaction.impl.Neo4jSynchronization;
import org.hibernate.ogm.datastore.neo4j.transaction.impl.RemoteTransactionDriver;
import org.hibernate.ogm.transaction.impl.ForwardingTransactionCoordinator;
import org.hibernate.resource.transaction.TransactionCoordinator;

public class HttpNeo4jJtaTransactionCoordinator
extends ForwardingTransactionCoordinator
implements BaseNeo4jJtaTransactionCoordinator {
    private final HttpNeo4jClient remoteNeo4j;
    private HttpNeo4jTransaction tx;

    public HttpNeo4jJtaTransactionCoordinator(TransactionCoordinator delegate, HttpNeo4jDatastoreProvider provider) {
        super(delegate);
        this.remoteNeo4j = provider.getClient();
    }

    public TransactionCoordinator.TransactionDriver getTransactionDriverControl() {
        return new RemoteTransactionDriver(this, super.getTransactionDriverControl());
    }

    public void explicitJoin() {
        super.explicitJoin();
        this.join();
    }

    public void pulse() {
        super.pulse();
        this.join();
    }

    @Override
    public void join() {
        if (this.tx == null && this.delegate.isActive() && this.delegate.getTransactionCoordinatorBuilder().isJta()) {
            this.beginTransaction();
            this.delegate.getLocalSynchronizations().registerSynchronization((Synchronization)new Neo4jSynchronization(this));
        }
    }

    @Override
    public void success() {
        if (this.tx != null) {
            this.tx.commit();
            this.tx = null;
        }
    }

    @Override
    public void failure() {
        if (this.tx != null) {
            this.tx.rollback();
            this.tx = null;
        }
    }

    @Override
    public boolean isTransactionOpen() {
        return this.tx != null;
    }

    @Override
    public Object getTransactionId() {
        if (this.tx == null) {
            return null;
        }
        return this.tx.getId();
    }

    @Override
    public void beginTransaction() {
        this.tx = this.remoteNeo4j.beginTx();
    }
}

