/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.neo4j.driver.v1.types.Node;

public class NodeWithEmbeddedNodes {
    private static final Map<String, Collection<Node>> EMPTY_MAP = Collections.emptyMap();
    private final Node owner;
    private final Map<String, Collection<Node>> embeddedNodes;

    public NodeWithEmbeddedNodes(Node owner) {
        this(owner, EMPTY_MAP);
    }

    public NodeWithEmbeddedNodes(Node owner, Map<String, Collection<Node>> embeddedNodes) {
        this.owner = owner;
        this.embeddedNodes = embeddedNodes == null ? EMPTY_MAP : Collections.unmodifiableMap(embeddedNodes);
    }

    public Node getOwner() {
        return this.owner;
    }

    public Map<String, Collection<Node>> getEmbeddedNodes() {
        return this.embeddedNodes;
    }
}

