/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.protobuf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.AssertionFailure;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.BooleanProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.ByteProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.CalendarDateProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.CharacterProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.DateProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.DoubleProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.FloatProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.IntegerProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.LongProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.PrimitiveBytearrayProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.ProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.ShortProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.StringProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.UnsafeProtofield;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtostreamMappedField;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.ProtobufFieldConsumer;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.ProtobufTypeConsumer;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.SanitationUtils;
import org.hibernate.ogm.type.descriptor.impl.AttributeConverterGridTypeDescriptorAdaptor;
import org.hibernate.ogm.type.descriptor.impl.GridTypeDescriptor;
import org.hibernate.ogm.type.impl.AttributeConverterGridTypeAdaptor;
import org.hibernate.ogm.type.impl.BigDecimalType;
import org.hibernate.ogm.type.impl.BigIntegerType;
import org.hibernate.ogm.type.impl.BooleanType;
import org.hibernate.ogm.type.impl.ByteType;
import org.hibernate.ogm.type.impl.CalendarDateType;
import org.hibernate.ogm.type.impl.CalendarType;
import org.hibernate.ogm.type.impl.CharacterType;
import org.hibernate.ogm.type.impl.DateType;
import org.hibernate.ogm.type.impl.DoubleType;
import org.hibernate.ogm.type.impl.EntityType;
import org.hibernate.ogm.type.impl.EnumType;
import org.hibernate.ogm.type.impl.FloatType;
import org.hibernate.ogm.type.impl.IntegerType;
import org.hibernate.ogm.type.impl.LongType;
import org.hibernate.ogm.type.impl.NumericBooleanType;
import org.hibernate.ogm.type.impl.PrimitiveByteArrayType;
import org.hibernate.ogm.type.impl.SerializableAsByteArrayType;
import org.hibernate.ogm.type.impl.ShortType;
import org.hibernate.ogm.type.impl.StringType;
import org.hibernate.ogm.type.impl.TimeType;
import org.hibernate.ogm.type.impl.TimestampType;
import org.hibernate.ogm.type.impl.TrueFalseType;
import org.hibernate.ogm.type.impl.UUIDType;
import org.hibernate.ogm.type.impl.UrlType;
import org.hibernate.ogm.type.impl.YesNoType;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.type.Type;

public class ProtofieldAccessorSet {
    private int uniqueTagAssigningCounter = 0;
    private List<UnsafeProtofield> orderedFields = new ArrayList<UnsafeProtofield>();
    private Map<String, UnsafeProtofield> fieldsPerORMName = new HashMap<String, UnsafeProtofield>();
    private Map<String, UnsafeProtofield> fieldsPerProtobufName = new HashMap<String, UnsafeProtofield>();

    public void addMapping(String ormMappedName, GridType gridType, Type ormType, boolean nullable) {
        String name = SanitationUtils.convertNameSafely(ormMappedName);
        ++this.uniqueTagAssigningCounter;
        if ((gridType = this.extractGridTypeOnRecursiveTypes(gridType, ormType)) instanceof StringType) {
            this.add(new StringProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof IntegerType) {
            this.add(new IntegerProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof LongType) {
            this.add(new LongProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof DoubleType) {
            this.add(new DoubleProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof UUIDType) {
            this.add(new StringProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof CalendarDateType) {
            this.add(new CalendarDateProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof CalendarType) {
            this.add(new CalendarDateProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof DateType) {
            this.add(new DateProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof TimestampType) {
            this.add(new DateProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof TimeType) {
            this.add(new DateProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof PrimitiveByteArrayType) {
            this.add(new PrimitiveBytearrayProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof SerializableAsByteArrayType) {
            this.add(new PrimitiveBytearrayProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof CharacterType) {
            this.add(new CharacterProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof ByteType) {
            this.add(new ByteProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof BooleanType) {
            this.add(new BooleanProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof TrueFalseType) {
            this.add(new CharacterProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof YesNoType) {
            this.add(new CharacterProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof NumericBooleanType) {
            this.add(new IntegerProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof BigDecimalType) {
            this.add(new StringProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof UrlType) {
            this.add(new StringProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof ShortType) {
            this.add(new ShortProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof BigIntegerType) {
            this.add(new StringProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof FloatType) {
            this.add(new FloatProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
        } else if (gridType instanceof EnumType) {
            EnumType etype = (EnumType)gridType;
            if (etype.isOrdinal()) {
                this.add(new IntegerProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
            } else {
                this.add(new StringProtofieldAccessor(this.uniqueTagAssigningCounter, name, nullable, ormMappedName));
            }
        } else {
            if (gridType instanceof EntityType) {
                throw new AssertionFailure("EntityType not implemented yet! " + gridType.getName());
            }
            throw new AssertionFailure("Type not implemented yet! " + gridType.getName());
        }
    }

    private GridType extractGridTypeOnRecursiveTypes(GridType gridType, Type ormType) {
        AttributeConverterGridTypeAdaptor acgta;
        GridTypeDescriptor descriptor;
        if (gridType instanceof AttributeConverterGridTypeAdaptor && (descriptor = (acgta = (AttributeConverterGridTypeAdaptor)gridType).getGridTypeDescriptor()) instanceof AttributeConverterGridTypeDescriptorAdaptor) {
            AttributeConverterGridTypeDescriptorAdaptor internalType = (AttributeConverterGridTypeDescriptorAdaptor)descriptor;
            return internalType.unwrapTargetGridType();
        }
        return gridType;
    }

    public void forEachProtobufFieldExporter(ProtobufFieldConsumer action) {
        this.orderedFields.forEach(action);
    }

    public void forEach(ProtobufTypeConsumer action) {
        this.orderedFields.forEach(action);
    }

    public void forEachProtostreamMappedField(Consumer<ProtostreamMappedField> action) {
        this.orderedFields.forEach(action);
    }

    private void add(ProtofieldAccessor unsafeWriter) {
        UnsafeProtofield wrapped = new UnsafeProtofield(unsafeWriter);
        UnsafeProtofield previous = this.fieldsPerORMName.put(unsafeWriter.getColumnName(), wrapped);
        if (previous != null) {
            throw new AssertionFailure("Duplicate or ambiguous property: '" + unsafeWriter.getColumnName());
        }
        previous = this.fieldsPerProtobufName.put(wrapped.getProtobufName(), wrapped);
        if (previous != null) {
            throw new AssertionFailure("Duplicate or ambiguous property after convertion to Protobuf requirements: '" + wrapped.getProtobufName() + "'");
        }
        this.orderedFields.add(wrapped);
    }

    public int size() {
        return this.orderedFields.size();
    }

    public UnsafeProtofield getDecoderByListOrder(int i) {
        return this.orderedFields.get(i);
    }

    public UnsafeProtofield getDecoderByColumnName(String columnName) {
        return this.fieldsPerORMName.get(columnName);
    }

    public boolean columnNameExists(String columnName) {
        return this.fieldsPerORMName.containsKey(columnName);
    }

    public String[] getColumnNames() {
        return this.fieldsPerORMName.keySet().toArray(new String[0]);
    }
}

