/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.protobuf;

import java.io.IOException;
import java.util.HashMap;
import org.hibernate.ogm.datastore.infinispanremote.impl.VersionedAssociation;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.ProtofieldAccessorSet;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.SchemaDefinitions;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.UnsafeProtofield;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.MainOgmCoDec;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtostreamAssociationPayload;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtostreamId;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtostreamPayload;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.spi.Tuple;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.protostream.MessageMarshaller;

public final class CompositeProtobufCoDec
implements MainOgmCoDec {
    private final String tableName;
    private final String protobufTypeName;
    private final String protobufIdTypeName;
    private final RemoteCache remoteCache;
    private final ProtofieldAccessorSet keyFields;
    private final ProtofieldAccessorSet valueFields;
    private final SchemaDefinitions sd;

    public CompositeProtobufCoDec(String tableName, String protobufTypeName, String protobufIdTypeName, ProtofieldAccessorSet keyFields, ProtofieldAccessorSet valueFields, RemoteCache remoteCache, SchemaDefinitions sd) {
        this.tableName = tableName;
        this.protobufTypeName = protobufTypeName;
        this.protobufIdTypeName = protobufIdTypeName;
        this.remoteCache = remoteCache;
        this.keyFields = keyFields;
        this.valueFields = valueFields;
        this.sd = sd;
    }

    @Override
    public RemoteCache getLinkedCache() {
        return this.remoteCache;
    }

    @Override
    public ProtostreamId readProtostreamId(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        int size = this.keyFields.size();
        String[] columnNames = new String[size];
        Object[] columnValues = new Object[size];
        for (int i = 0; i < size; ++i) {
            UnsafeProtofield protoField = this.keyFields.getDecoderByListOrder(i);
            columnNames[i] = protoField.getColumnName();
            columnValues[i] = protoField.read(reader);
        }
        return this.createIdPayload(columnNames, columnValues);
    }

    @Override
    public ProtostreamId createIdPayload(String[] columnNames, Object[] columnValues) {
        assert (this.verifyAllColumnNamesArePartOfId(columnNames));
        return new ProtostreamId(columnNames, columnValues);
    }

    private boolean verifyAllColumnNamesArePartOfId(String[] columnNames) {
        for (String name : columnNames) {
            if (this.keyFields.columnNameExists(name)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeIdTo(MessageMarshaller.ProtoStreamWriter writer, ProtostreamId id) throws IOException {
        int size = id.columnNames.length;
        for (int i = 0; i < size; ++i) {
            String columnName = id.columnNames[i];
            UnsafeProtofield protofieldWriter = this.keyFields.getDecoderByColumnName(columnName);
            if (protofieldWriter == null) continue;
            protofieldWriter.writeTo(writer, id.columnValues[i]);
        }
    }

    @Override
    public ProtostreamPayload readPayloadFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        int size = this.valueFields.size();
        HashMap mapTuple = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            UnsafeProtofield protoField = this.valueFields.getDecoderByListOrder(i);
            String column = protoField.getColumnName();
            Object value = protoField.read(reader);
            if (value == null) continue;
            mapTuple.put(column, value);
        }
        MapTupleSnapshot loadedSnapshot = new MapTupleSnapshot(mapTuple);
        return new ProtostreamPayload(loadedSnapshot);
    }

    @Override
    public void writePayloadTo(MessageMarshaller.ProtoStreamWriter writer, ProtostreamPayload payload) {
        this.valueFields.forEachProtostreamMappedField(f -> {
            Object columnValue = payload.getColumnValue(f.getColumnName());
            if (columnValue != null) {
                f.writeTo(writer, columnValue);
            }
        });
    }

    @Override
    public ProtostreamPayload createValuePayload(Tuple tuple) {
        return new ProtostreamPayload(tuple);
    }

    @Override
    public String getProtobufTypeName() {
        return this.protobufTypeName;
    }

    @Override
    public String getIdProtobufTypeName() {
        return this.protobufIdTypeName;
    }

    @Override
    public ProtostreamAssociationPayload createAssociationPayload(EntityKey key, VersionedAssociation assoc, TupleContext tupleContext) {
        return new ProtostreamAssociationPayload(assoc);
    }

    @Override
    public String convertColumnNameToFieldName(String columnName) {
        return this.valueFields.getDecoderByColumnName(columnName).getProtobufName();
    }

    @Override
    public String[] listIdColumnNames() {
        return this.keyFields.getColumnNames();
    }
}

