/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.protobuf;

import java.io.IOException;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.NullableProtofieldEncoder;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.ProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.ProtofieldDecoder;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.ProtofieldEncoder;
import org.infinispan.protostream.MessageMarshaller;

public abstract class BaseProtofieldAccessor<T>
implements ProtofieldAccessor<T> {
    protected final int fieldNumber;
    protected final String name;
    protected final String columnName;
    protected final boolean nullable;
    protected final ProtofieldEncoder<T> writingFunction;
    protected final ProtofieldDecoder<T> readingFunction;

    public BaseProtofieldAccessor(int fieldLabel, String fieldName, boolean nullable, String columnName, ProtofieldEncoder<T> writingFunction, ProtofieldDecoder<T> readingFunction) {
        this.fieldNumber = fieldLabel;
        this.name = fieldName;
        this.columnName = columnName;
        this.nullable = nullable;
        this.readingFunction = readingFunction;
        this.writingFunction = NullableProtofieldEncoder.makeNullableFieldEncoder(writingFunction, nullable);
    }

    @Override
    public void writeTo(MessageMarshaller.ProtoStreamWriter outProtobuf, T value) throws IOException {
        this.writingFunction.encode(outProtobuf, value);
    }

    @Override
    public T read(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        return this.readingFunction.read(reader);
    }

    @Override
    public void exportProtobufFieldDefinition(StringBuilder sb) {
        if (this.nullable) {
            sb.append("\n\toptional ");
        } else {
            sb.append("\n\trequired ");
        }
        sb.append(this.getProtobufTypeName()).append(" ").append(this.name).append(" = ").append(this.fieldNumber).append(";");
    }

    protected abstract String getProtobufTypeName();

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public String getProtobufName() {
        return this.name;
    }
}

