/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.centrality;

import java.util.Comparator;
import java.util.Set;
import org.neo4j.graphalgo.impl.centrality.Eccentricity;
import org.neo4j.graphalgo.impl.centrality.ShortestPathBasedCentrality;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPath;
import org.neo4j.graphdb.Node;

public class NetworkRadius<ShortestPathCostType>
extends ShortestPathBasedCentrality<ShortestPathCostType, ShortestPathCostType> {
    Comparator<ShortestPathCostType> distanceComparator;
    protected Eccentricity<ShortestPathCostType> eccentricity;
    protected ShortestPathCostType radius;

    public NetworkRadius(SingleSourceShortestPath<ShortestPathCostType> singleSourceShortestPath, ShortestPathCostType zeroValue, Set<Node> nodeSet, Comparator<ShortestPathCostType> distanceComparator) {
        super(singleSourceShortestPath, null, zeroValue, nodeSet);
        this.distanceComparator = distanceComparator;
        this.eccentricity = new Eccentricity<ShortestPathCostType>(singleSourceShortestPath, zeroValue, nodeSet, distanceComparator);
    }

    @Override
    public void processShortestPaths(Node node, SingleSourceShortestPath<ShortestPathCostType> singleSourceShortestPath) {
        this.eccentricity.processShortestPaths(node, singleSourceShortestPath);
        ShortestPathCostType centrality = this.eccentricity.getCentrality(node);
        if (this.radius == null || this.distanceComparator.compare(centrality, this.radius) < 0) {
            this.radius = centrality;
        }
    }

    @Override
    public ShortestPathCostType getCentrality(Node node) {
        if (node != null) {
            throw new RuntimeException("Getting network radius with a specific node as argument, which means nonsense.");
        }
        this.calculate();
        return this.radius;
    }
}

