/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.OffHeapPageLock;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionEventOpportunity;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;
import org.neo4j.unsafe.impl.internal.dragons.MemoryManager;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

class PageList {
    private static final boolean forceSlowMemoryClear = FeatureToggles.flag(PageList.class, (String)"forceSlowMemoryClear", (boolean)false);
    private static final int META_DATA_BYTES_PER_PAGE = 32;
    private static final int OFFSET_LOCK_WORD = 0;
    private static final int OFFSET_ADDRESS = 8;
    private static final int OFFSET_FILE_PAGE_ID = 16;
    private static final int OFFSET_SWAPPER_ID = 24;
    private static final int OFFSET_USAGE_COUNTER = 28;
    private final int pageCount;
    private final int cachePageSize;
    private final MemoryManager memoryManager;
    private final SwapperSet swappers;
    private final long victimPageAddress;
    private final long baseAddress;

    PageList(int pageCount, int cachePageSize, MemoryManager memoryManager, SwapperSet swappers, long victimPageAddress) {
        this.pageCount = pageCount;
        this.cachePageSize = cachePageSize;
        this.memoryManager = memoryManager;
        this.swappers = swappers;
        this.victimPageAddress = victimPageAddress;
        long bytes = (long)pageCount * 32L;
        this.baseAddress = memoryManager.allocateAligned(bytes);
        this.clearMemory(this.baseAddress, pageCount);
    }

    PageList(PageList pageList) {
        this.pageCount = pageList.pageCount;
        this.cachePageSize = pageList.cachePageSize;
        this.memoryManager = pageList.memoryManager;
        this.swappers = pageList.swappers;
        this.victimPageAddress = pageList.victimPageAddress;
        this.baseAddress = pageList.baseAddress;
    }

    private void clearMemory(long baseAddress, long pageCount) {
        long memcpyChunkSize = UnsafeUtil.pageSize();
        long metaDataEntriesPerChunk = memcpyChunkSize / 32L;
        if (pageCount < metaDataEntriesPerChunk || forceSlowMemoryClear) {
            this.clearMemorySimple(baseAddress, pageCount);
        } else {
            this.clearMemoryFast(baseAddress, pageCount, memcpyChunkSize, metaDataEntriesPerChunk);
        }
        UnsafeUtil.fullFence();
    }

    private void clearMemorySimple(long baseAddress, long pageCount) {
        long address = baseAddress - 8L;
        for (long i = 0L; i < pageCount; ++i) {
            UnsafeUtil.putLong((long)(address += 8L), (long)OffHeapPageLock.initialLockWordWithExclusiveLock());
            UnsafeUtil.putLong((long)(address += 8L), (long)0L);
            UnsafeUtil.putLong((long)(address += 8L), (long)-1L);
            UnsafeUtil.putLong((long)(address += 8L), (long)0L);
        }
    }

    private void clearMemoryFast(long baseAddress, long pageCount, long memcpyChunkSize, long metaDataEntriesPerChunk) {
        this.clearMemorySimple(baseAddress, metaDataEntriesPerChunk);
        long chunkCopies = pageCount / metaDataEntriesPerChunk - 1L;
        long address = baseAddress + memcpyChunkSize;
        int i = 0;
        while ((long)i < chunkCopies) {
            UnsafeUtil.copyMemory((long)baseAddress, (long)address, (long)memcpyChunkSize);
            address += memcpyChunkSize;
            ++i;
        }
        long tailCount = pageCount % metaDataEntriesPerChunk;
        this.clearMemorySimple(address, tailCount);
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public SwapperSet getSwappers() {
        return this.swappers;
    }

    public long deref(int pageId) {
        long id = pageId;
        return this.baseAddress + id * 32L;
    }

    public int toId(long pageRef) {
        return (int)(pageRef - this.baseAddress >> 5);
    }

    private long offLock(long pageRef) {
        return pageRef + 0L;
    }

    private long offAddress(long pageRef) {
        return pageRef + 8L;
    }

    private long offUsage(long pageRef) {
        return pageRef + 28L;
    }

    private long offFilePageId(long pageRef) {
        return pageRef + 16L;
    }

    private long offSwapperId(long pageRef) {
        return pageRef + 24L;
    }

    public long tryOptimisticReadLock(long pageRef) {
        return OffHeapPageLock.tryOptimisticReadLock(this.offLock(pageRef));
    }

    public boolean validateReadLock(long pageRef, long stamp) {
        return OffHeapPageLock.validateReadLock(this.offLock(pageRef), stamp);
    }

    public boolean isModified(long pageRef) {
        return OffHeapPageLock.isModified(this.offLock(pageRef));
    }

    public boolean isExclusivelyLocked(long pageRef) {
        return OffHeapPageLock.isExclusivelyLocked(this.offLock(pageRef));
    }

    public boolean tryWriteLock(long pageRef) {
        return OffHeapPageLock.tryWriteLock(this.offLock(pageRef));
    }

    public void unlockWrite(long pageRef) {
        OffHeapPageLock.unlockWrite(this.offLock(pageRef));
    }

    public long unlockWriteAndTryTakeFlushLock(long pageRef) {
        return OffHeapPageLock.unlockWriteAndTryTakeFlushLock(this.offLock(pageRef));
    }

    public boolean tryExclusiveLock(long pageRef) {
        return OffHeapPageLock.tryExclusiveLock(this.offLock(pageRef));
    }

    public long unlockExclusive(long pageRef) {
        return OffHeapPageLock.unlockExclusive(this.offLock(pageRef));
    }

    public void unlockExclusiveAndTakeWriteLock(long pageRef) {
        OffHeapPageLock.unlockExclusiveAndTakeWriteLock(this.offLock(pageRef));
    }

    public long tryFlushLock(long pageRef) {
        return OffHeapPageLock.tryFlushLock(this.offLock(pageRef));
    }

    public void unlockFlush(long pageRef, long stamp, boolean success) {
        OffHeapPageLock.unlockFlush(this.offLock(pageRef), stamp, success);
    }

    public void explicitlyMarkPageUnmodifiedUnderExclusiveLock(long pageRef) {
        OffHeapPageLock.explicitlyMarkPageUnmodifiedUnderExclusiveLock(this.offLock(pageRef));
    }

    public int getCachePageSize() {
        return this.cachePageSize;
    }

    public long getAddress(long pageRef) {
        return UnsafeUtil.getLong((long)this.offAddress(pageRef));
    }

    public void initBuffer(long pageRef) {
        if (this.getAddress(pageRef) == 0L) {
            long addr = this.memoryManager.allocateAligned((long)this.getCachePageSize());
            UnsafeUtil.putLong((long)this.offAddress(pageRef), (long)addr);
        }
    }

    private byte getUsageCounter(long pageRef) {
        return UnsafeUtil.getByteVolatile((long)this.offUsage(pageRef));
    }

    private void setUsageCounter(long pageRef, byte count) {
        UnsafeUtil.putByteVolatile((long)this.offUsage(pageRef), (byte)count);
    }

    public void incrementUsage(long pageRef) {
        byte usage = this.getUsageCounter(pageRef);
        if (usage < 4) {
            usage = (byte)(usage + 1);
            this.setUsageCounter(pageRef, usage);
        }
    }

    public boolean decrementUsage(long pageRef) {
        byte usage = this.getUsageCounter(pageRef);
        if (usage > 0) {
            usage = (byte)(usage - 1);
            this.setUsageCounter(pageRef, usage);
        }
        return usage == 0;
    }

    public long getFilePageId(long pageRef) {
        return UnsafeUtil.getLong((long)this.offFilePageId(pageRef));
    }

    private void setFilePageId(long pageRef, long filePageId) {
        UnsafeUtil.putLong((long)this.offFilePageId(pageRef), (long)filePageId);
    }

    public int getSwapperId(long pageRef) {
        return UnsafeUtil.getInt((long)this.offSwapperId(pageRef));
    }

    private void setSwapperId(long pageRef, int swapperId) {
        UnsafeUtil.putInt((long)this.offSwapperId(pageRef), (int)swapperId);
    }

    public boolean isLoaded(long pageRef) {
        return this.getFilePageId(pageRef) != -1L;
    }

    public boolean isBoundTo(long pageRef, int swapperId, long filePageId) {
        return this.getSwapperId(pageRef) == swapperId && this.getFilePageId(pageRef) == filePageId;
    }

    public void fault(long pageRef, PageSwapper swapper, int swapperId, long filePageId, PageFaultEvent event) throws IOException {
        if (swapper == null) {
            throw PageList.swapperCannotBeNull();
        }
        int currentSwapper = this.getSwapperId(pageRef);
        long currentFilePageId = this.getFilePageId(pageRef);
        if (filePageId == -1L || !this.isExclusivelyLocked(pageRef) || currentSwapper != 0 || currentFilePageId != -1L) {
            throw PageList.cannotFaultException(pageRef, swapper, swapperId, filePageId, currentSwapper, currentFilePageId);
        }
        this.setFilePageId(pageRef, filePageId);
        long bytesRead = swapper.read(filePageId, this.getAddress(pageRef), this.cachePageSize);
        event.addBytesRead(bytesRead);
        event.setCachePageId(this.toId(pageRef));
        this.setSwapperId(pageRef, swapperId);
    }

    private static IllegalArgumentException swapperCannotBeNull() {
        return new IllegalArgumentException("swapper cannot be null");
    }

    private static IllegalStateException cannotFaultException(long pageRef, PageSwapper swapper, int swapperId, long filePageId, int currentSwapper, long currentFilePageId) {
        String msg = String.format("Cannot fault page {filePageId = %s, swapper = %s (swapper id = %s)} into cache page %s. Already bound to {filePageId = %s, swapper id = %s}.", filePageId, swapper, swapperId, pageRef, currentFilePageId, currentSwapper);
        return new IllegalStateException(msg);
    }

    public boolean tryEvict(long pageRef, EvictionEventOpportunity evictionOpportunity) throws IOException {
        if (this.tryExclusiveLock(pageRef)) {
            if (this.isLoaded(pageRef)) {
                try (EvictionEvent evictionEvent = evictionOpportunity.beginEviction();){
                    this.evict(pageRef, evictionEvent);
                    boolean bl = true;
                    return bl;
                }
            }
            this.unlockExclusive(pageRef);
        }
        return false;
    }

    private void evict(long pageRef, EvictionEvent evictionEvent) throws IOException {
        SwapperSet.SwapperMapping swapperMapping;
        long filePageId = this.getFilePageId(pageRef);
        evictionEvent.setFilePageId(filePageId);
        evictionEvent.setCachePageId(pageRef);
        int swapperId = this.getSwapperId(pageRef);
        if (swapperId != 0 && (swapperMapping = this.swappers.getAllocation(swapperId)) != null) {
            PageSwapper swapper = swapperMapping.swapper;
            evictionEvent.setSwapper(swapper);
            if (this.isModified(pageRef)) {
                this.flushModifiedPage(pageRef, evictionEvent, filePageId, swapper);
            }
            swapper.evicted(filePageId);
        }
        this.clearBinding(pageRef);
    }

    private void flushModifiedPage(long pageRef, EvictionEvent evictionEvent, long filePageId, PageSwapper swapper) throws IOException {
        FlushEvent flushEvent = evictionEvent.flushEventOpportunity().beginFlush(filePageId, pageRef, swapper);
        try {
            long address = this.getAddress(pageRef);
            long bytesWritten = swapper.write(filePageId, address);
            this.explicitlyMarkPageUnmodifiedUnderExclusiveLock(pageRef);
            flushEvent.addBytesWritten(bytesWritten);
            flushEvent.addPagesFlushed(1);
            flushEvent.done();
        }
        catch (IOException e) {
            this.unlockExclusive(pageRef);
            flushEvent.done(e);
            evictionEvent.threwException(e);
            throw e;
        }
    }

    protected void clearBinding(long pageRef) {
        this.setFilePageId(pageRef, -1L);
        this.setSwapperId(pageRef, 0);
    }

    public String toString(long pageRef) {
        StringBuilder sb = new StringBuilder();
        this.toString(pageRef, sb);
        return sb.toString();
    }

    public void toString(long pageRef, StringBuilder sb) {
        sb.append("Page[ id = ").append(this.toId(pageRef));
        sb.append(", address = ").append(this.getAddress(pageRef));
        sb.append(", filePageId = ").append(this.getFilePageId(pageRef));
        sb.append(", swapperId = ").append(this.getSwapperId(pageRef));
        sb.append(", usageCounter = ").append(this.getUsageCounter(pageRef));
        sb.append(" ] ").append(OffHeapPageLock.toString(this.offLock(pageRef)));
    }
}

