/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Iterator;
import org.neo4j.helpers.collection.PrefetchingIterator;

public class IdRangeInput
extends PrefetchingIterator<Range> {
    private final long max;
    private final int batchSize;
    private long start;

    public IdRangeInput(long max, int batchSize) {
        this.max = max;
        this.batchSize = batchSize;
    }

    protected Range fetchNextOrNull() {
        int count = (int)Long.min(this.batchSize, this.max - this.start);
        if (count == 0) {
            return null;
        }
        try {
            Range range = new Range(this.start, count);
            return range;
        }
        finally {
            this.start += (long)count;
        }
    }

    public static Iterator<Range> idRangeInput(long max, int batchSize) {
        return new IdRangeInput(max, batchSize);
    }

    public static class Range {
        private final long start;
        private final int size;

        Range(long start, int size) {
            this.start = start;
            this.size = size;
        }

        public long getStart() {
            return this.start;
        }

        public int getSize() {
            return this.size;
        }
    }
}

