/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class Recovery
extends LifecycleAdapter {
    private final SPI spi;
    private final Monitor monitor;
    private int numberOfRecoveredTransactions;
    private boolean recoveredLog;

    public Recovery(SPI spi, Monitor monitor) {
        this.spi = spi;
        this.monitor = monitor;
    }

    public void init() throws Throwable {
        LogPosition recoveryToPosition;
        Throwable throwable;
        LogPosition recoveryFromPosition = this.spi.getPositionToRecoverFrom();
        if (LogPosition.UNSPECIFIED.equals(recoveryFromPosition)) {
            return;
        }
        this.monitor.recoveryRequired(recoveryFromPosition);
        this.spi.startRecovery();
        long lowestRecoveredTxId = 1L;
        try (TransactionCursor transactionsToRecover = this.spi.getTransactionsInReverseOrder(recoveryFromPosition);){
            throwable = null;
            try (RecoveryApplier recoveryVisitor = this.spi.getRecoveryApplier(TransactionApplicationMode.REVERSE_RECOVERY);){
                while (transactionsToRecover.next()) {
                    recoveryVisitor.visit(transactionsToRecover.get());
                    lowestRecoveredTxId = ((CommittedTransactionRepresentation)transactionsToRecover.get()).getCommitEntry().getTxId();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        this.monitor.reverseStoreRecoveryCompleted(lowestRecoveredTxId);
        CommittedTransactionRepresentation lastTransaction = null;
        throwable = null;
        try (TransactionCursor transactionsToRecover = this.spi.getTransactions(recoveryFromPosition);
             RecoveryApplier recoveryVisitor = this.spi.getRecoveryApplier(TransactionApplicationMode.RECOVERY);){
            while (transactionsToRecover.next()) {
                lastTransaction = (CommittedTransactionRepresentation)transactionsToRecover.get();
                long txId = lastTransaction.getCommitEntry().getTxId();
                recoveryVisitor.visit(lastTransaction);
                this.monitor.transactionRecovered(txId);
                ++this.numberOfRecoveredTransactions;
            }
            recoveryToPosition = transactionsToRecover.position();
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        if (recoveryToPosition.equals(LogPosition.UNSPECIFIED)) {
            recoveryToPosition = recoveryFromPosition;
        }
        this.spi.allTransactionsRecovered(lastTransaction, recoveryToPosition);
        this.recoveredLog = true;
    }

    public void start() throws Throwable {
        if (this.recoveredLog) {
            this.monitor.recoveryCompleted(this.numberOfRecoveredTransactions);
        }
    }

    public static interface SPI {
        public TransactionCursor getTransactions(LogPosition var1) throws IOException;

        public TransactionCursor getTransactionsInReverseOrder(LogPosition var1) throws IOException;

        public LogPosition getPositionToRecoverFrom() throws IOException;

        public void startRecovery();

        public RecoveryApplier getRecoveryApplier(TransactionApplicationMode var1) throws Exception;

        public void allTransactionsRecovered(CommittedTransactionRepresentation var1, LogPosition var2) throws Exception;
    }

    public static interface RecoveryApplier
    extends Visitor<CommittedTransactionRepresentation, Exception>,
    AutoCloseable {
    }

    public static interface Monitor {
        default public void recoveryRequired(LogPosition recoveryPosition) {
        }

        default public void transactionRecovered(long txId) {
        }

        default public void recoveryCompleted(int numberOfRecoveredTransactions) {
        }

        default public void reverseStoreRecoveryCompleted(long lowestRecoveredTxId) {
        }
    }
}

