/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.DirectionIdentifier;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordAccessSet;
import org.neo4j.kernel.impl.transaction.state.RelationshipConnection;
import org.neo4j.kernel.impl.transaction.state.RelationshipGroupGetter;
import org.neo4j.kernel.impl.util.DirectionWrapper;
import org.neo4j.storageengine.api.lock.ResourceLocker;

public class RelationshipCreator {
    private final RelationshipGroupGetter relGroupGetter;
    private final int denseNodeThreshold;

    public RelationshipCreator(RelationshipGroupGetter relGroupGetter, int denseNodeThreshold) {
        this.relGroupGetter = relGroupGetter;
        this.denseNodeThreshold = denseNodeThreshold;
    }

    public void relationshipCreate(long id, int type, long firstNodeId, long secondNodeId, RecordAccessSet recordChangeSet, ResourceLocker locks) {
        NodeRecord firstNode = recordChangeSet.getNodeRecords().getOrLoad(firstNodeId, null).forChangingLinkage();
        NodeRecord secondNode = recordChangeSet.getNodeRecords().getOrLoad(secondNodeId, null).forChangingLinkage();
        this.convertNodeToDenseIfNecessary(firstNode, recordChangeSet.getRelRecords(), recordChangeSet.getRelGroupRecords(), locks);
        this.convertNodeToDenseIfNecessary(secondNode, recordChangeSet.getRelRecords(), recordChangeSet.getRelGroupRecords(), locks);
        RelationshipRecord record = recordChangeSet.getRelRecords().create(id, null).forChangingLinkage();
        record.setLinks(firstNodeId, secondNodeId, type);
        record.setInUse(true);
        record.setCreated();
        this.connectRelationship(firstNode, secondNode, record, recordChangeSet.getRelRecords(), recordChangeSet.getRelGroupRecords(), locks);
    }

    public static int relCount(long nodeId, RelationshipRecord rel) {
        return (int)(nodeId == rel.getFirstNode() ? rel.getFirstPrevRel() : rel.getSecondPrevRel());
    }

    private void convertNodeToDenseIfNecessary(NodeRecord node, RecordAccess<RelationshipRecord, Void> relRecords, RecordAccess<RelationshipGroupRecord, Integer> relGroupRecords, ResourceLocker locks) {
        if (node.isDense()) {
            return;
        }
        long relId = node.getNextRel();
        if (relId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RecordAccess.RecordProxy<RelationshipRecord, Object> relChange = relRecords.getOrLoad(relId, null);
            RelationshipRecord rel = relChange.forReadingLinkage();
            if (RelationshipCreator.relCount(node.getId(), rel) >= this.denseNodeThreshold) {
                locks.acquireExclusive(LockTracer.NONE, ResourceTypes.RELATIONSHIP, relId);
                relChange = relRecords.getOrLoad(relId, null);
                this.convertNodeToDenseNode(node, relChange.forChangingLinkage(), relRecords, relGroupRecords, locks);
            }
        }
    }

    private void connectRelationship(NodeRecord firstNode, NodeRecord secondNode, RelationshipRecord rel, RecordAccess<RelationshipRecord, Void> relRecords, RecordAccess<RelationshipGroupRecord, Integer> relGroupRecords, ResourceLocker locks) {
        assert (firstNode.getNextRel() != rel.getId() || firstNode.isDense());
        assert (secondNode.getNextRel() != rel.getId() || secondNode.isDense());
        if (!firstNode.isDense()) {
            rel.setFirstNextRel(firstNode.getNextRel());
        }
        if (!secondNode.isDense()) {
            rel.setSecondNextRel(secondNode.getNextRel());
        }
        if (!firstNode.isDense()) {
            this.connect(firstNode, rel, relRecords, locks);
        } else {
            this.connectRelationshipToDenseNode(firstNode, rel, relRecords, relGroupRecords, locks);
        }
        if (!secondNode.isDense()) {
            if (firstNode.getId() != secondNode.getId()) {
                this.connect(secondNode, rel, relRecords, locks);
            } else {
                rel.setFirstInFirstChain(true);
                rel.setSecondPrevRel(rel.getFirstPrevRel());
            }
        } else if (firstNode.getId() != secondNode.getId()) {
            this.connectRelationshipToDenseNode(secondNode, rel, relRecords, relGroupRecords, locks);
        }
        if (!firstNode.isDense()) {
            firstNode.setNextRel(rel.getId());
        }
        if (!secondNode.isDense()) {
            secondNode.setNextRel(rel.getId());
        }
    }

    private void connectRelationshipToDenseNode(NodeRecord node, RelationshipRecord rel, RecordAccess<RelationshipRecord, Void> relRecords, RecordAccess<RelationshipGroupRecord, Integer> relGroupRecords, ResourceLocker locks) {
        RelationshipGroupRecord group = this.relGroupGetter.getOrCreateRelationshipGroup(node, rel.getType(), relGroupRecords).forChangingData();
        DirectionWrapper dir = DirectionIdentifier.wrapDirection(rel, node);
        long nextRel = dir.getNextRel(group);
        this.setCorrectNextRel(node, rel, nextRel);
        this.connect(node.getId(), nextRel, rel, relRecords, locks);
        dir.setNextRel(group, rel.getId());
    }

    private void connect(NodeRecord node, RelationshipRecord rel, RecordAccess<RelationshipRecord, Void> relRecords, ResourceLocker locks) {
        this.connect(node.getId(), node.getNextRel(), rel, relRecords, locks);
    }

    private void convertNodeToDenseNode(NodeRecord node, RelationshipRecord firstRel, RecordAccess<RelationshipRecord, Void> relRecords, RecordAccess<RelationshipGroupRecord, Integer> relGroupRecords, ResourceLocker locks) {
        node.setDense(true);
        node.setNextRel(Record.NO_NEXT_RELATIONSHIP.intValue());
        long relId = firstRel.getId();
        RelationshipRecord relRecord = firstRel;
        while (relId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            relId = RelationshipCreator.relChain(relRecord, node.getId()).get(relRecord);
            this.connectRelationshipToDenseNode(node, relRecord, relRecords, relGroupRecords, locks);
            if (relId == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) continue;
            locks.acquireExclusive(LockTracer.NONE, ResourceTypes.RELATIONSHIP, relId);
            relRecord = relRecords.getOrLoad(relId, null).forChangingLinkage();
        }
    }

    private void connect(long nodeId, long firstRelId, RelationshipRecord rel, RecordAccess<RelationshipRecord, Void> relRecords, ResourceLocker locks) {
        long newCount = 1L;
        if (firstRelId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            locks.acquireExclusive(LockTracer.NONE, ResourceTypes.RELATIONSHIP, firstRelId);
            RelationshipRecord firstRel = relRecords.getOrLoad(firstRelId, null).forChangingLinkage();
            boolean changed = false;
            if (firstRel.getFirstNode() == nodeId) {
                newCount = firstRel.getFirstPrevRel() + 1L;
                firstRel.setFirstPrevRel(rel.getId());
                firstRel.setFirstInFirstChain(false);
                changed = true;
            }
            if (firstRel.getSecondNode() == nodeId) {
                newCount = firstRel.getSecondPrevRel() + 1L;
                firstRel.setSecondPrevRel(rel.getId());
                firstRel.setFirstInSecondChain(false);
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(nodeId + " doesn't match " + firstRel);
            }
        }
        if (rel.getFirstNode() == nodeId) {
            rel.setFirstPrevRel(newCount);
            rel.setFirstInFirstChain(true);
        }
        if (rel.getSecondNode() == nodeId) {
            rel.setSecondPrevRel(newCount);
            rel.setFirstInSecondChain(true);
        }
    }

    private void setCorrectNextRel(NodeRecord node, RelationshipRecord rel, long nextRel) {
        if (node.getId() == rel.getFirstNode()) {
            rel.setFirstNextRel(nextRel);
        }
        if (node.getId() == rel.getSecondNode()) {
            rel.setSecondNextRel(nextRel);
        }
    }

    private static RelationshipConnection relChain(RelationshipRecord rel, long nodeId) {
        if (rel.getFirstNode() == nodeId) {
            return RelationshipConnection.START_NEXT;
        }
        if (rel.getSecondNode() == nodeId) {
            return RelationshipConnection.END_NEXT;
        }
        throw new RuntimeException(nodeId + " neither start not end node in " + rel);
    }
}

