/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.rotation;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvent;
import org.neo4j.kernel.internal.DatabaseHealth;

public class LogRotationImpl
implements LogRotation {
    private final LogRotation.Monitor monitor;
    private final LogFile logFile;
    private final DatabaseHealth databaseHealth;

    public LogRotationImpl(LogRotation.Monitor monitor, LogFile logFile, DatabaseHealth databaseHealth) {
        this.monitor = monitor;
        this.logFile = logFile;
        this.databaseHealth = databaseHealth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rotateLogIfNeeded(LogAppendEvent logAppendEvent) throws IOException {
        if (this.logFile.rotationNeeded()) {
            LogFile logFile = this.logFile;
            synchronized (logFile) {
                if (this.logFile.rotationNeeded()) {
                    try (LogRotateEvent rotateEvent = logAppendEvent.beginLogRotate();){
                        this.doRotate();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rotateLogFile() throws IOException {
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            this.doRotate();
        }
    }

    private void doRotate() throws IOException {
        long currentVersion = this.logFile.currentLogVersion();
        this.databaseHealth.assertHealthy(IOException.class);
        this.monitor.startedRotating(currentVersion);
        this.logFile.rotate();
        this.monitor.finishedRotating(currentVersion);
    }
}

