/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;

public final class FileCountThreshold
implements Threshold {
    private final long maxNonEmptyLogs;
    private long nonEmptyLogCount;

    public FileCountThreshold(long maxNonEmptyLogs) {
        this.maxNonEmptyLogs = maxNonEmptyLogs;
    }

    @Override
    public void init() {
        this.nonEmptyLogCount = 0L;
    }

    @Override
    public boolean reached(File file, long version, LogFileInformation source) {
        return ++this.nonEmptyLogCount >= this.maxNonEmptyLogs;
    }

    public String toString() {
        return "[max:" + this.maxNonEmptyLogs + "]";
    }
}

