/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.util.concurrent.TimeUnit;
import org.neo4j.time.SystemNanoClock;

public class RotationTimerFactory {
    private SystemNanoClock clock;
    private long timeoutMillis;

    public RotationTimerFactory(SystemNanoClock clock, long timeoutMillis) {
        this.clock = clock;
        this.timeoutMillis = timeoutMillis;
    }

    public RotationTimer createTimer() {
        long startTimeNanos = this.clock.nanos();
        long timeoutNanos = TimeUnit.MILLISECONDS.toNanos(this.timeoutMillis);
        return new RotationTimer(startTimeNanos, startTimeNanos + timeoutNanos);
    }

    class RotationTimer {
        private long startTimeNanos;
        private long deadlineNanos;

        RotationTimer(long startTimeNanos, long deadlineNanos) {
            this.startTimeNanos = startTimeNanos;
            this.deadlineNanos = deadlineNanos;
        }

        public boolean isTimedOut() {
            return RotationTimerFactory.this.clock.nanos() > this.deadlineNanos;
        }

        public long getElapsedTimeMillis() {
            long elapsedNanos = RotationTimerFactory.this.clock.nanos() - this.startTimeNanos;
            return TimeUnit.NANOSECONDS.toMillis(elapsedNanos);
        }
    }
}

