/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.kernel.impl.api.index.sampling.DefaultNonUniqueIndexSampler;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.NonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;
import org.neo4j.storageengine.api.schema.IndexSample;

class FullScanNonUniqueIndexSampler<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue>
extends NonUniqueIndexSampler.Adapter {
    private final GBPTree<KEY, VALUE> gbpTree;
    private final Layout<KEY, VALUE> layout;
    private final IndexSamplingConfig samplingConfig;

    FullScanNonUniqueIndexSampler(GBPTree<KEY, VALUE> gbpTree, Layout<KEY, VALUE> layout, IndexSamplingConfig samplingConfig) {
        this.gbpTree = gbpTree;
        this.layout = layout;
        this.samplingConfig = samplingConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IndexSample result() {
        SchemaNumberKey lowest = (SchemaNumberKey)((Object)this.layout.newKey());
        lowest.initAsLowest();
        SchemaNumberKey highest = (SchemaNumberKey)((Object)this.layout.newKey());
        highest.initAsHighest();
        try (RawCursor seek = this.gbpTree.seek((Object)lowest, (Object)highest);){
            DefaultNonUniqueIndexSampler sampler = new DefaultNonUniqueIndexSampler(this.samplingConfig.sampleSizeLimit());
            while (seek.next()) {
                Hit hit = (Hit)seek.get();
                sampler.include(((SchemaNumberKey)((Object)hit.key())).propertiesAsString());
            }
            IndexSample indexSample = sampler.result();
            return indexSample;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public IndexSample result(int numDocs) {
        throw new UnsupportedOperationException();
    }
}

