/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.impl.coreapi.ExplicitIndexProxy;
import org.neo4j.kernel.impl.coreapi.IndexProvider;
import org.neo4j.kernel.impl.coreapi.RelationshipExplicitIndexProxy;

public class IndexProviderImpl
implements IndexProvider {
    private final Supplier<Statement> transactionBridge;
    private final GraphDatabaseService gds;

    public IndexProviderImpl(GraphDatabaseService gds, Supplier<Statement> transactionBridge) {
        this.gds = gds;
        this.transactionBridge = transactionBridge;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Index<Node> getOrCreateNodeIndex(String indexName, Map<String, String> customConfiguration) {
        try (Statement statement = this.transactionBridge.get();){
            if (!statement.readOperations().nodeExplicitIndexExists(indexName, customConfiguration)) {
                statement.dataWriteOperations().nodeExplicitIndexCreateLazily(indexName, customConfiguration);
            }
            ExplicitIndexProxy<Node> explicitIndexProxy = new ExplicitIndexProxy<Node>(indexName, ExplicitIndexProxy.Type.NODE, this.gds, this.transactionBridge);
            return explicitIndexProxy;
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RelationshipIndex getOrCreateRelationshipIndex(String indexName, Map<String, String> customConfiguration) {
        try (Statement statement = this.transactionBridge.get();){
            if (!statement.readOperations().relationshipExplicitIndexExists(indexName, customConfiguration)) {
                statement.dataWriteOperations().relationshipExplicitIndexCreateLazily(indexName, customConfiguration);
            }
            RelationshipExplicitIndexProxy relationshipExplicitIndexProxy = new RelationshipExplicitIndexProxy(indexName, this.gds, this.transactionBridge);
            return relationshipExplicitIndexProxy;
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }
}

