/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonValue;
import org.bson.Document;
import org.hibernate.ogm.datastore.mongodb.type.AbstractGeoJsonObject;
import org.hibernate.ogm.datastore.mongodb.type.GeoPoint;
import org.hibernate.ogm.util.Experimental;
import org.hibernate.ogm.util.impl.Contracts;

@Experimental
public class GeoPolygon
extends AbstractGeoJsonObject {
    private static final String TYPE = "Polygon";
    private List<List<GeoPoint>> rings = new ArrayList<List<GeoPoint>>(1);

    public GeoPolygon(List<GeoPoint> exteriorRing) {
        super(TYPE);
        Contracts.assertNotNull(exteriorRing, (String)"exteriorRing");
        this.rings.add(exteriorRing);
    }

    public GeoPolygon(GeoPoint firstPoint, GeoPoint secondPoint, GeoPoint thirdPoint, GeoPoint fourthPoint, GeoPoint ... additionalPoints) {
        super(TYPE);
        Contracts.assertNotNull((Object)firstPoint, (String)"firstPoint");
        Contracts.assertNotNull((Object)secondPoint, (String)"secondPoint");
        Contracts.assertNotNull((Object)thirdPoint, (String)"thirdPoint");
        Contracts.assertNotNull((Object)fourthPoint, (String)"fourthPoint");
        Contracts.assertNotNull((Object)additionalPoints, (String)"additionalPoints");
        ArrayList<GeoPoint> exteriorRing = new ArrayList<GeoPoint>(4 + additionalPoints.length);
        exteriorRing.add(firstPoint);
        exteriorRing.add(secondPoint);
        exteriorRing.add(thirdPoint);
        exteriorRing.add(fourthPoint);
        exteriorRing.addAll(Arrays.asList(additionalPoints));
        this.rings.add(exteriorRing);
    }

    public GeoPolygon addHole(List<GeoPoint> hole) {
        Contracts.assertNotNull(hole, (String)"hole");
        this.rings.add(hole);
        return this;
    }

    public GeoPolygon addHole(GeoPoint firstPoint, GeoPoint secondPoint, GeoPoint thirdPoint, GeoPoint fourthPoint, GeoPoint ... additionalPoints) {
        Contracts.assertNotNull((Object)firstPoint, (String)"firstPoint");
        Contracts.assertNotNull((Object)secondPoint, (String)"secondPoint");
        Contracts.assertNotNull((Object)thirdPoint, (String)"thirdPoint");
        Contracts.assertNotNull((Object)fourthPoint, (String)"fourthPoint");
        Contracts.assertNotNull((Object)additionalPoints, (String)"additionalPoints");
        ArrayList<GeoPoint> hole = new ArrayList<GeoPoint>(4 + additionalPoints.length);
        hole.add(firstPoint);
        hole.add(secondPoint);
        hole.add(thirdPoint);
        hole.add(fourthPoint);
        hole.addAll(Arrays.asList(additionalPoints));
        this.rings.add(hole);
        return this;
    }

    public GeoPolygon addHoles(List<List<GeoPoint>> holes) {
        Contracts.assertNotNull(holes, (String)"holes");
        this.rings.addAll(holes);
        return this;
    }

    public List<GeoPoint> getExternalRing() {
        return this.rings.get(0);
    }

    public List<List<GeoPoint>> getRings() {
        return this.rings;
    }

    @Override
    protected BsonArray toCoordinates() {
        BsonArray coordinates = new BsonArray();
        for (List<GeoPoint> ring : this.rings) {
            BsonArray ringCoordinates = new BsonArray();
            for (GeoPoint geoPoint : ring) {
                ringCoordinates.add((BsonValue)geoPoint.toCoordinates());
            }
            coordinates.add((BsonValue)ringCoordinates);
        }
        return coordinates;
    }

    static GeoPolygon fromCoordinates(List<List<List<Double>>> coordinates) {
        if (coordinates == null) {
            return null;
        }
        ArrayList rings = new ArrayList(coordinates.size());
        for (List<List<Double>> ringCoordinates : coordinates) {
            List ring = ringCoordinates.stream().map(GeoPoint::fromCoordinates).collect(Collectors.toList());
            rings.add(ring);
        }
        GeoPolygon geoPolygon = new GeoPolygon((List)rings.get(0));
        geoPolygon.addHoles(rings.subList(1, rings.size()));
        return geoPolygon;
    }

    public static GeoPolygon fromDocument(Document document) {
        if (document == null) {
            return null;
        }
        GeoPolygon.checkType(TYPE, document);
        List coordinates = (List)document.get((Object)"coordinates");
        if (coordinates == null) {
            return null;
        }
        return GeoPolygon.fromCoordinates(coordinates);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GeoPolygon that = (GeoPolygon)obj;
        return that.rings.equals(this.rings);
    }

    public int hashCode() {
        return this.rings.hashCode();
    }

    public String toString() {
        return "GeoPolygon [rings=" + this.rings + "]";
    }
}

