/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.type;

import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonDouble;
import org.bson.BsonValue;
import org.bson.Document;
import org.hibernate.ogm.datastore.mongodb.type.AbstractGeoJsonObject;
import org.hibernate.ogm.util.Experimental;
import org.hibernate.ogm.util.impl.Contracts;

@Experimental
public class GeoPoint
extends AbstractGeoJsonObject {
    private static final String TYPE = "Point";
    private double longitude;
    private double latitude;

    public GeoPoint(double longitude, double latitude) {
        super(TYPE);
        Contracts.assertNotNull((Object)longitude, (String)"longitude");
        Contracts.assertNotNull((Object)latitude, (String)"latitude");
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    @Override
    protected BsonArray toCoordinates() {
        BsonArray coordinates = new BsonArray();
        coordinates.add((BsonValue)new BsonDouble(this.longitude));
        coordinates.add((BsonValue)new BsonDouble(this.latitude));
        return coordinates;
    }

    static GeoPoint fromCoordinates(List<Double> coordinates) {
        if (coordinates == null) {
            return null;
        }
        return new GeoPoint(coordinates.get(0), coordinates.get(1));
    }

    public static GeoPoint fromDocument(Document document) {
        if (document == null) {
            return null;
        }
        GeoPoint.checkType(TYPE, document);
        List coordinates = (List)document.get((Object)"coordinates");
        return GeoPoint.fromCoordinates(coordinates);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GeoPoint that = (GeoPoint)obj;
        if (that.longitude != this.longitude) {
            return false;
        }
        return that.latitude == this.latitude;
    }

    public int hashCode() {
        int hashCode = Double.valueOf(this.longitude).hashCode();
        hashCode = hashCode * 31 + Double.valueOf(this.latitude).hashCode();
        return hashCode;
    }

    public String toString() {
        return "GeoPoint [longitude=" + this.longitude + ", latitude=" + this.latitude + "]";
    }
}

