/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonValue;
import org.bson.Document;
import org.hibernate.ogm.datastore.mongodb.type.AbstractGeoJsonObject;
import org.hibernate.ogm.datastore.mongodb.type.GeoPolygon;
import org.hibernate.ogm.util.Experimental;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.hibernate.ogm.util.impl.Contracts;

@Experimental
public class GeoMultiPolygon
extends AbstractGeoJsonObject {
    private static final String TYPE = "MultiPolygon";
    private List<GeoPolygon> polygons;

    public GeoMultiPolygon(List<GeoPolygon> polygons) {
        super(TYPE);
        this.polygons = polygons;
    }

    public GeoMultiPolygon(GeoPolygon firstPolygon, GeoPolygon ... additionalPolygons) {
        super(TYPE);
        Contracts.assertNotNull((Object)firstPolygon, (String)"firstPolygon");
        Contracts.assertNotNull((Object)additionalPolygons, (String)"additionalPolygons");
        this.polygons = new ArrayList<Object>(Arrays.asList(ArrayHelper.concat((Object)firstPolygon, (Object[])additionalPolygons)));
    }

    public List<GeoPolygon> getPolygons() {
        return this.polygons;
    }

    @Override
    protected BsonArray toCoordinates() {
        BsonArray coordinates = new BsonArray();
        for (GeoPolygon geoPolygon : this.polygons) {
            coordinates.add((BsonValue)geoPolygon.toCoordinates());
        }
        return coordinates;
    }

    public static GeoMultiPolygon fromDocument(Document document) {
        if (document == null) {
            return null;
        }
        GeoMultiPolygon.checkType(TYPE, document);
        List polygonsCoordinates = (List)document.get((Object)"coordinates");
        if (polygonsCoordinates == null) {
            return null;
        }
        List<GeoPolygon> geoPolygons = polygonsCoordinates.stream().map(GeoPolygon::fromCoordinates).collect(Collectors.toList());
        return new GeoMultiPolygon(geoPolygons);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GeoMultiPolygon that = (GeoMultiPolygon)obj;
        return that.polygons.equals(this.polygons);
    }

    public int hashCode() {
        return this.polygons.hashCode();
    }

    public String toString() {
        return "GeoMultiPolygon [polygons=" + this.polygons + "]";
    }
}

