/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl;

import java.util.regex.Pattern;
import org.bson.Document;
import org.hibernate.hql.ast.spi.predicate.LikePredicate;
import org.hibernate.hql.ast.spi.predicate.NegatablePredicate;
import org.hibernate.ogm.util.parser.impl.LikeExpressionToRegExpConverter;

public class MongoDBLikePredicate
extends LikePredicate<Document>
implements NegatablePredicate<Document> {
    private final Pattern pattern;

    public MongoDBLikePredicate(String propertyName, String patternValue, Character escapeCharacter) {
        super(propertyName, patternValue, escapeCharacter);
        LikeExpressionToRegExpConverter converter = new LikeExpressionToRegExpConverter(escapeCharacter);
        this.pattern = converter.getRegExpFromLikeExpression(patternValue);
    }

    public Document getQuery() {
        return new Document(this.propertyName, (Object)this.pattern);
    }

    public Document getNegatedQuery() {
        return new Document(this.propertyName, (Object)new Document("$not", (Object)this.pattern));
    }
}

