/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.dialect.impl;

import java.util.Set;
import java.util.regex.Pattern;
import org.bson.Document;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoHelpers;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.TupleSnapshot;

public class MongoDBTupleSnapshot
implements TupleSnapshot {
    public static final Pattern EMBEDDED_FIELDNAME_SEPARATOR = Pattern.compile("\\.");
    private final Document dbObject;
    private final EntityKeyMetadata keyMetadata;

    public MongoDBTupleSnapshot(Document dbObject, EntityKeyMetadata meta) {
        this.dbObject = dbObject;
        this.keyMetadata = meta;
    }

    public Document getDbObject() {
        return this.dbObject;
    }

    public Set<String> getColumnNames() {
        return this.dbObject.keySet();
    }

    public boolean isEmpty() {
        return this.dbObject.keySet().isEmpty();
    }

    public boolean isKeyColumn(String column) {
        return this.keyMetadata != null && this.keyMetadata.isKeyColumn(column);
    }

    public Object get(String column) {
        return this.isKeyColumn(column) ? this.getKeyColumnValue(column) : this.getValue(this.dbObject, column);
    }

    private Object getKeyColumnValue(String column) {
        Object idField = this.dbObject.get((Object)"_id");
        if (this.keyMetadata.getColumnNames().length == 1) {
            return idField;
        }
        if (column.contains(".")) {
            column = column.substring(column.indexOf(".") + 1);
        }
        return this.getValue((Document)idField, column);
    }

    private Object getValue(Document dbObject, String column) {
        Object valueOrNull = MongoHelpers.getValueOrNull(dbObject, column);
        return valueOrNull;
    }
}

