/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import java.util.Map;
import java.util.Properties;

public class JndiHelper {
    public static Properties extractJndiProperties(Map configurationValues) {
        Properties jndiProperties = new Properties();
        for (Map.Entry entry : configurationValues.entrySet()) {
            if (!String.class.isInstance(entry.getKey())) continue;
            String propertyName = (String)entry.getKey();
            Object propertyValue = entry.getValue();
            if (!propertyName.startsWith("hibernate.jndi")) continue;
            if ("hibernate.jndi.class".equals(propertyName)) {
                if (propertyValue == null) continue;
                jndiProperties.put("java.naming.factory.initial", propertyValue);
                continue;
            }
            if ("hibernate.jndi.url".equals(propertyName)) {
                if (propertyValue == null) continue;
                jndiProperties.put("java.naming.provider.url", propertyValue);
                continue;
            }
            String passThruPropertyname = propertyName.substring("hibernate.jndi".length() + 1);
            jndiProperties.put(passThruPropertyname, propertyValue);
        }
        return jndiProperties;
    }
}

