/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;

public class CollectionHelper {
    private CollectionHelper() {
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... ts) {
        if (ts == null) {
            return null;
        }
        if (ts.length == 0) {
            return Collections.emptySet();
        }
        HashSet set = new HashSet(CollectionHelper.getInitialCapacityFromExpectedSize(ts.length));
        Collections.addAll(set, ts);
        return Collections.unmodifiableSet(set);
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet(int initialCapacity) {
        return new LinkedHashSet(CollectionHelper.getInitialCapacityFromExpectedSize(initialCapacity));
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int initialCapacity) {
        return new HashMap(CollectionHelper.getInitialCapacityFromExpectedSize(initialCapacity));
    }

    public static <K, V> HashMap<K, V> newHashMap(Map<? extends K, ? extends V> other) {
        return new HashMap<K, V>(other);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int initialCapacity) {
        return new LinkedHashMap(CollectionHelper.getInitialCapacityFromExpectedSize(initialCapacity));
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Map<? extends K, ? extends V> other) {
        return new LinkedHashMap<K, V>(other);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(Map<? extends K, ? extends V> other) {
        return new ConcurrentHashMap<K, V>(other);
    }

    public static <T> ClosableIterator<T> newClosableIterator(Iterable<T> iterable) {
        return new ClosableIteratorWrapper(iterable.iterator());
    }

    public static boolean isEmptyOrContainsOnlyNull(Object[] objects) {
        for (Object object : objects) {
            if (object == null) continue;
            return false;
        }
        return true;
    }

    private static int getInitialCapacityFromExpectedSize(int expectedSize) {
        if (expectedSize < 3) {
            return expectedSize + 1;
        }
        return (int)((float)expectedSize / 0.75f + 1.0f);
    }

    private static class ClosableIteratorWrapper<T>
    implements ClosableIterator<T> {
        private final Iterator<T> iterator;

        private ClosableIteratorWrapper(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public void close() {
        }
    }
}

