/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.cfg.AttributeConverterDefinition;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.type.descriptor.impl.AttributeConverterGridTypeDescriptorAdaptor;
import org.hibernate.ogm.type.impl.AbstractGenericBasicType;
import org.hibernate.ogm.type.impl.AttributeConverterGridTypeAdaptor;
import org.hibernate.ogm.type.impl.BigDecimalType;
import org.hibernate.ogm.type.impl.BigIntegerType;
import org.hibernate.ogm.type.impl.BooleanType;
import org.hibernate.ogm.type.impl.ByteType;
import org.hibernate.ogm.type.impl.CalendarDateType;
import org.hibernate.ogm.type.impl.CalendarType;
import org.hibernate.ogm.type.impl.CharacterType;
import org.hibernate.ogm.type.impl.ClassType;
import org.hibernate.ogm.type.impl.CollectionType;
import org.hibernate.ogm.type.impl.ComponentType;
import org.hibernate.ogm.type.impl.DateType;
import org.hibernate.ogm.type.impl.DoubleType;
import org.hibernate.ogm.type.impl.EnumType;
import org.hibernate.ogm.type.impl.FloatType;
import org.hibernate.ogm.type.impl.IntegerType;
import org.hibernate.ogm.type.impl.LongType;
import org.hibernate.ogm.type.impl.ManyToOneType;
import org.hibernate.ogm.type.impl.NumericBooleanType;
import org.hibernate.ogm.type.impl.OneToOneType;
import org.hibernate.ogm.type.impl.PrimitiveByteArrayType;
import org.hibernate.ogm.type.impl.SerializableAsByteArrayType;
import org.hibernate.ogm.type.impl.ShortType;
import org.hibernate.ogm.type.impl.StringType;
import org.hibernate.ogm.type.impl.TimeType;
import org.hibernate.ogm.type.impl.TimestampType;
import org.hibernate.ogm.type.impl.TrueFalseType;
import org.hibernate.ogm.type.impl.UUIDType;
import org.hibernate.ogm.type.impl.UrlType;
import org.hibernate.ogm.type.impl.YesNoType;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.ogm.util.impl.CollectionHelper;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.type.AbstractStandardBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BinaryType;
import org.hibernate.type.CustomType;
import org.hibernate.type.ImageType;
import org.hibernate.type.MaterializedBlobType;
import org.hibernate.type.MaterializedClobType;
import org.hibernate.type.SerializableToBlobType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;
import org.hibernate.type.UUIDBinaryType;
import org.hibernate.type.UUIDCharType;
import org.hibernate.type.descriptor.converter.AttributeConverterTypeAdapter;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptorRegistry;
import org.hibernate.usertype.UserType;

public class TypeTranslatorImpl
implements TypeTranslator {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final Map<Type, GridType> typeConverter;
    private final GridDialect dialect;
    private final TypeResolver typeResolver;

    public TypeTranslatorImpl(GridDialect dialect, TypeResolver typeResolver) {
        this.dialect = dialect;
        this.typeResolver = typeResolver;
        HashMap<Object, AbstractGenericBasicType> tmpMap = CollectionHelper.newHashMap(20);
        tmpMap.put(org.hibernate.type.ClassType.INSTANCE, ClassType.INSTANCE);
        tmpMap.put(org.hibernate.type.LongType.INSTANCE, LongType.INSTANCE);
        tmpMap.put(org.hibernate.type.IntegerType.INSTANCE, IntegerType.INSTANCE);
        tmpMap.put(org.hibernate.type.DoubleType.INSTANCE, DoubleType.INSTANCE);
        tmpMap.put(org.hibernate.type.FloatType.INSTANCE, FloatType.INSTANCE);
        tmpMap.put(org.hibernate.type.ShortType.INSTANCE, ShortType.INSTANCE);
        tmpMap.put(org.hibernate.type.CharacterType.INSTANCE, CharacterType.INSTANCE);
        tmpMap.put(org.hibernate.type.StringType.INSTANCE, StringType.INSTANCE);
        tmpMap.put(org.hibernate.type.UrlType.INSTANCE, UrlType.INSTANCE);
        tmpMap.put(org.hibernate.type.BigDecimalType.INSTANCE, BigDecimalType.INSTANCE);
        tmpMap.put(org.hibernate.type.BigIntegerType.INSTANCE, BigIntegerType.INSTANCE);
        tmpMap.put(org.hibernate.type.BooleanType.INSTANCE, BooleanType.INSTANCE);
        tmpMap.put(org.hibernate.type.TrueFalseType.INSTANCE, TrueFalseType.INSTANCE);
        tmpMap.put(org.hibernate.type.YesNoType.INSTANCE, YesNoType.INSTANCE);
        tmpMap.put(org.hibernate.type.NumericBooleanType.INSTANCE, NumericBooleanType.INSTANCE);
        tmpMap.put(org.hibernate.type.ByteType.INSTANCE, ByteType.INSTANCE);
        tmpMap.put(org.hibernate.type.DateType.INSTANCE, DateType.INSTANCE);
        tmpMap.put(org.hibernate.type.TimestampType.INSTANCE, TimestampType.INSTANCE);
        tmpMap.put(org.hibernate.type.TimeType.INSTANCE, TimeType.INSTANCE);
        tmpMap.put(org.hibernate.type.CalendarDateType.INSTANCE, CalendarDateType.INSTANCE);
        tmpMap.put(org.hibernate.type.CalendarType.INSTANCE, CalendarType.INSTANCE);
        tmpMap.put(BinaryType.INSTANCE, PrimitiveByteArrayType.INSTANCE);
        tmpMap.put(MaterializedBlobType.INSTANCE, PrimitiveByteArrayType.INSTANCE);
        tmpMap.put(MaterializedClobType.INSTANCE, StringType.INSTANCE);
        tmpMap.put(ImageType.INSTANCE, PrimitiveByteArrayType.INSTANCE);
        tmpMap.put(UUIDBinaryType.INSTANCE, UUIDType.INSTANCE);
        tmpMap.put(UUIDCharType.INSTANCE, UUIDType.INSTANCE);
        this.typeConverter = Collections.unmodifiableMap(tmpMap);
    }

    @Override
    public GridType getType(Type type) {
        if (type == null) {
            return null;
        }
        GridType dialectType = this.dialect.overrideType(type);
        if (dialectType != null) {
            return dialectType;
        }
        if (type instanceof SerializableToBlobType) {
            SerializableToBlobType exposedType = (SerializableToBlobType)type;
            return new SerializableAsByteArrayType(exposedType.getJavaTypeDescriptor());
        }
        if (type instanceof AttributeConverterTypeAdapter) {
            return this.buildAttributeConverterGridTypeAdaptor((AttributeConverterTypeAdapter)type);
        }
        if (type instanceof AbstractStandardBasicType) {
            AbstractStandardBasicType exposedType = (AbstractStandardBasicType)type;
            GridType gridType = this.typeConverter.get(exposedType);
            if (gridType == null) {
                throw log.unableToFindGridType(exposedType.getName());
            }
            return gridType;
        }
        if (type instanceof CustomType) {
            CustomType cType = (CustomType)type;
            UserType userType = cType.getUserType();
            if (userType instanceof org.hibernate.type.EnumType) {
                org.hibernate.type.EnumType enumType = (org.hibernate.type.EnumType)userType;
                return new EnumType(cType, enumType);
            }
        } else {
            if (type instanceof org.hibernate.type.ComponentType) {
                org.hibernate.type.ComponentType componentType = (org.hibernate.type.ComponentType)type;
                return new ComponentType(componentType, this);
            }
            if (type instanceof org.hibernate.type.ManyToOneType) {
                org.hibernate.type.ManyToOneType manyToOneType = (org.hibernate.type.ManyToOneType)type;
                return new ManyToOneType(manyToOneType, (TypeTranslator)this);
            }
            if (type instanceof org.hibernate.type.OneToOneType) {
                org.hibernate.type.OneToOneType oneToOneType = (org.hibernate.type.OneToOneType)type;
                return new OneToOneType(oneToOneType, (TypeTranslator)this);
            }
            if (type instanceof org.hibernate.type.CollectionType) {
                return new CollectionType((org.hibernate.type.CollectionType)type);
            }
        }
        throw log.unableToFindGridType(type.getClass().getName());
    }

    private <T> AttributeConverterGridTypeAdaptor<T> buildAttributeConverterGridTypeAdaptor(AttributeConverterTypeAdapter<T> specificType) {
        AttributeConverterDefinition attributeConverterDefinition = new AttributeConverterDefinition(specificType.getAttributeConverter(), false);
        Class databaseColumnJavaType = attributeConverterDefinition.getDatabaseColumnType();
        BasicType intermediaryORMType = this.typeResolver.basic(databaseColumnJavaType.getName());
        if (intermediaryORMType == null) {
            throw log.cannotFindTypeForAttributeConverter(specificType.getAttributeConverter().getClass(), databaseColumnJavaType);
        }
        GridType intermediaryOGMGridType = this.getType((Type)intermediaryORMType);
        JavaTypeDescriptor intermediateJavaTypeDescriptor = JavaTypeDescriptorRegistry.INSTANCE.getDescriptor(databaseColumnJavaType);
        AttributeConverterGridTypeDescriptorAdaptor gridTypeDescriptorAdapter = new AttributeConverterGridTypeDescriptorAdaptor(attributeConverterDefinition.getAttributeConverter(), intermediaryOGMGridType, intermediateJavaTypeDescriptor);
        return new AttributeConverterGridTypeAdaptor<T>(specificType, gridTypeDescriptorAdapter);
    }
}

