/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type.descriptor.impl;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.NonContextualLobCreator;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.type.descriptor.impl.GridTypeDescriptor;
import org.hibernate.ogm.type.descriptor.impl.GridValueBinder;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public abstract class BasicGridBinder<X>
implements GridValueBinder<X> {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final WrapperOptions DEFAULT_OPTIONS = new WrapperOptions(){

        public boolean useStreamForLobBinding() {
            return false;
        }

        public LobCreator getLobCreator() {
            return NonContextualLobCreator.INSTANCE;
        }

        public SqlTypeDescriptor remapSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
            return sqlTypeDescriptor;
        }
    };
    private final JavaTypeDescriptor<X> javaDescriptor;
    private final GridTypeDescriptor gridDescriptor;

    public BasicGridBinder(JavaTypeDescriptor<X> javaDescriptor, GridTypeDescriptor gridDescriptor) {
        this.javaDescriptor = javaDescriptor;
        this.gridDescriptor = gridDescriptor;
    }

    @Override
    public void bind(Tuple resultset, X value, String[] names) {
        if (value == null) {
            for (String name : names) {
                log.tracef("binding [null] to parameter [%1$s]", name);
                resultset.put(name, null);
            }
        } else {
            if (log.isTraceEnabled()) {
                log.tracef("binding [%1$s] to parameter(s) %2$s", this.javaDescriptor.extractLoggableRepresentation(value), Arrays.toString(names));
            }
            this.doBind(resultset, value, names, DEFAULT_OPTIONS);
        }
    }

    protected abstract void doBind(Tuple var1, X var2, String[] var3, WrapperOptions var4);
}

