/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.query.impl;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.event.spi.EventSource;
import org.hibernate.hql.internal.ast.HqlParser;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.QueryTranslatorImpl;
import org.hibernate.hql.internal.ast.tree.SelectClause;
import org.hibernate.hql.internal.ast.util.NodeTraverser;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;
import org.hibernate.ogm.dialect.query.spi.BackendQuery;
import org.hibernate.ogm.model.spi.EntityMetadataInformation;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.query.impl.LegacyParserBridgeQueryTranslator;
import org.hibernate.ogm.query.impl.OgmQueryLoader;
import org.hibernate.ogm.query.spi.QueryParserService;
import org.hibernate.ogm.query.spi.QueryParsingResult;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class OgmQueryTranslator
extends LegacyParserBridgeQueryTranslator {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final String query;
    private final SessionFactoryImplementor sessionFactory;
    private final Map<?, ?> filters;
    private final QueryParserService queryParser;
    private OgmQueryLoader loader;
    private SelectClause selectClause;
    private EntityMetadataInformation singleEntityMetadataInformation;
    private final ConcurrentMap<CacheKey, QueryParsingResult> queryCache;

    public OgmQueryTranslator(SessionFactoryImplementor sessionFactory, QueryParserService queryParser, String queryIdentifier, String query, Map<?, ?> filters) {
        super(sessionFactory, queryIdentifier, query, filters);
        this.queryParser = queryParser;
        this.query = query;
        this.sessionFactory = sessionFactory;
        this.filters = filters;
        this.queryCache = new BoundedConcurrentHashMap(100, 20, BoundedConcurrentHashMap.Eviction.LIRS);
    }

    @Override
    protected void doCompile(Map replacements, boolean shallow) throws QueryException, MappingException {
        try {
            this.selectClause = this.getSelectClause(replacements, null);
            Type[] queryReturnTypes = this.selectClause.getQueryReturnTypes();
            this.singleEntityMetadataInformation = this.determineSingleEntityInformation(queryReturnTypes);
        }
        catch (Exception qse) {
            throw log.querySyntaxException(qse, this.query);
        }
        if (this.queryParser.supportsParameters()) {
            this.loader = this.getLoader(null);
        }
    }

    public List<?> list(SessionImplementor session, QueryParameters queryParameters) throws HibernateException {
        OgmQueryLoader loaderToUse = this.loader != null ? this.loader : this.getLoader(queryParameters);
        return loaderToUse.list(session, queryParameters);
    }

    private <T> OgmQueryLoader getLoader(QueryParameters queryParameters) {
        QueryParsingResult queryParsingResult = queryParameters != null ? this.getQuery(queryParameters) : this.queryParser.parseQuery(this.sessionFactory, this.query);
        BackendQuery<Object> query = new BackendQuery<Object>(queryParsingResult.getQueryObject(), this.singleEntityMetadataInformation);
        return new OgmQueryLoader(this.delegate, this.sessionFactory, this.selectClause, query, queryParsingResult.getColumnNames());
    }

    private EntityMetadataInformation determineSingleEntityInformation(Type[] queryReturnTypes) {
        EntityMetadataInformation metadataInformation = null;
        for (Type queryReturn : queryReturnTypes) {
            if (!(queryReturn instanceof EntityType)) continue;
            if (metadataInformation != null) {
                return null;
            }
            EntityType rootReturn = (EntityType)queryReturn;
            OgmEntityPersister persister = (OgmEntityPersister)this.sessionFactory.getEntityPersister(rootReturn.getName());
            metadataInformation = new EntityMetadataInformation(persister.getEntityKeyMetadata(), rootReturn.getReturnedClass().getName());
        }
        return metadataInformation;
    }

    private QueryParsingResult getQuery(QueryParameters queryParameters) {
        QueryParsingResult cached;
        CacheKey cacheKey = new CacheKey(queryParameters.getNamedParameters());
        QueryParsingResult parsingResult = (QueryParsingResult)this.queryCache.get(cacheKey);
        if (parsingResult == null && (cached = this.queryCache.putIfAbsent(cacheKey, parsingResult = this.queryParser.parseQuery(this.sessionFactory, this.query, this.getNamedParameterValuesConvertedByGridType(queryParameters)))) != null) {
            parsingResult = cached;
        }
        return parsingResult;
    }

    private Map<String, Object> getNamedParameterValuesConvertedByGridType(QueryParameters queryParameters) {
        HashMap<String, Object> parameterValues = new HashMap<String, Object>(queryParameters.getNamedParameters().size());
        for (Map.Entry parameter : queryParameters.getNamedParameters().entrySet()) {
            parameterValues.put((String)parameter.getKey(), ((TypedValue)parameter.getValue()).getValue());
        }
        return parameterValues;
    }

    public Iterator<?> iterate(QueryParameters queryParameters, EventSource session) throws HibernateException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ScrollableResults scroll(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public int executeUpdate(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private SelectClause getSelectClause(Map<?, ?> replacements, String collectionRole) throws Exception {
        if (replacements == null) {
            replacements = Collections.emptyMap();
        }
        HqlParser parser = this.parse(true);
        HqlSqlWalker w = this.analyze(parser, replacements, collectionRole);
        return w.getSelectClause();
    }

    private HqlSqlWalker analyze(HqlParser parser, Map<?, ?> tokenReplacements, String collectionRole) throws QueryException, RecognitionException {
        HqlSqlWalker w = new HqlSqlWalker(this.delegate, this.sessionFactory, parser, tokenReplacements, collectionRole){

            public Map getEnabledFilters() {
                return OgmQueryTranslator.this.filters;
            }
        };
        AST hqlAst = parser.getAST();
        w.statement(hqlAst);
        w.getParseErrorHandler().throwQueryException();
        return w;
    }

    private HqlParser parse(boolean filter) throws TokenStreamException, RecognitionException {
        HqlParser parser = HqlParser.getInstance((String)this.query);
        parser.setFilter(filter);
        parser.statement();
        AST hqlAst = parser.getAST();
        NodeTraverser walker = new NodeTraverser((NodeTraverser.VisitationStrategy)new QueryTranslatorImpl.JavaConstantConverter(this.sessionFactory));
        walker.traverseDepthFirst(hqlAst);
        parser.getParseErrorHandler().throwQueryException();
        return parser;
    }

    private static class CacheKey {
        private final Map<String, TypedValue> parameters;
        private final int hashCode;

        public CacheKey(Map<String, TypedValue> parameters) {
            this.parameters = Collections.unmodifiableMap(parameters);
            this.hashCode = parameters.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
        }
    }
}

