/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.options.navigation.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.ogm.options.container.impl.OptionsContainer;
import org.hibernate.ogm.options.navigation.source.impl.OptionValueSource;
import org.hibernate.ogm.options.spi.Option;
import org.hibernate.ogm.options.spi.OptionsContext;
import org.hibernate.ogm.options.spi.UniqueOption;
import org.hibernate.ogm.util.impl.CollectionHelper;

public class OptionsContextImpl
implements OptionsContext {
    private final List<OptionValueSource> sources;
    private final Class<?> entityType;
    private final String propertyName;
    private final List<Class<?>> hierarchy;
    private final ConcurrentMap<Class<? extends Option<?, ?>>, OptionsContainer> optionCache;

    private OptionsContextImpl(List<OptionValueSource> sources, Class<?> entityType, String propertyName) {
        this.sources = sources;
        this.entityType = entityType;
        this.propertyName = propertyName;
        this.hierarchy = OptionsContextImpl.getClassHierarchy(entityType);
        this.optionCache = CollectionHelper.newConcurrentHashMap();
    }

    public static OptionsContext forGlobal(List<OptionValueSource> sources) {
        return new OptionsContextImpl(sources, null, null);
    }

    public static OptionsContext forProperty(List<OptionValueSource> sources, Class<?> entityType, String propertyName) {
        return new OptionsContextImpl(sources, entityType, propertyName);
    }

    public static OptionsContext forEntity(List<OptionValueSource> sources, Class<?> entityType) {
        return new OptionsContextImpl(sources, entityType, null);
    }

    @Override
    public <I, V, O extends Option<I, V>> V get(Class<O> optionType, I identifier) {
        OptionsContainer optionsContainer = (OptionsContainer)this.optionCache.get(optionType);
        if (optionsContainer == null) {
            optionsContainer = this.getAndCacheOptionsContainer(optionType);
        }
        return optionsContainer.get(optionType, identifier);
    }

    @Override
    public <V, O extends UniqueOption<V>> V getUnique(Class<O> optionType) {
        OptionsContainer optionsContainer = (OptionsContainer)this.optionCache.get(optionType);
        if (optionsContainer == null) {
            optionsContainer = this.getAndCacheOptionsContainer(optionType);
        }
        return optionsContainer.getUnique(optionType);
    }

    @Override
    public <I, V, O extends Option<I, V>> Map<I, V> getAll(Class<O> optionType) {
        OptionsContainer optionsContainer = (OptionsContainer)this.optionCache.get(optionType);
        if (optionsContainer == null) {
            optionsContainer = this.getAndCacheOptionsContainer(optionType);
        }
        return optionsContainer.getAll(optionType);
    }

    private <I, V, O extends Option<I, V>> OptionsContainer getAndCacheOptionsContainer(Class<O> optionType) {
        OptionsContainer container = this.getMostSpecificContainer(optionType);
        OptionsContainer cachedContainer = this.optionCache.putIfAbsent(optionType, container);
        if (cachedContainer != null) {
            container = cachedContainer;
        }
        return container;
    }

    private <I, V, O extends Option<I, V>> OptionsContainer getMostSpecificContainer(Class<O> optionType) {
        OptionsContainer container;
        if (this.propertyName != null) {
            for (Class clazz : this.hierarchy) {
                for (OptionValueSource source : this.sources) {
                    container = source.getPropertyOptions(clazz, this.propertyName);
                    if (container.getAll(optionType).isEmpty()) continue;
                    return container;
                }
            }
        }
        if (this.entityType != null) {
            for (Class clazz : this.hierarchy) {
                for (OptionValueSource source : this.sources) {
                    container = source.getEntityOptions(clazz);
                    if (container.getAll(optionType).isEmpty()) continue;
                    return container;
                }
            }
        }
        for (OptionValueSource optionValueSource : this.sources) {
            container = optionValueSource.getGlobalOptions();
            if (container.getAll(optionType).isEmpty()) continue;
            return container;
        }
        return OptionsContainer.EMPTY;
    }

    private static List<Class<?>> getClassHierarchy(Class<?> clazz) {
        ArrayList hierarchy = new ArrayList(4);
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            hierarchy.add(current);
        }
        return hierarchy;
    }

    public String toString() {
        return "OptionsContextImpl [entityType=" + this.entityType + ", propertyName=" + this.propertyName + "]";
    }
}

