/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.options.container.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.options.container.impl.OptionsContainer;
import org.hibernate.ogm.options.spi.Option;
import org.hibernate.ogm.options.spi.UniqueOption;
import org.hibernate.ogm.util.impl.CollectionHelper;

public class OptionsContainerBuilder {
    private final Map<Class<? extends Option<?, ?>>, ValueContainerBuilder<?, ?>> optionValues = CollectionHelper.newHashMap();

    public <I, V> void add(Option<I, V> option, V value) {
        this.getOrCreateValueContainer(option).add(option.getOptionIdentifier(), value);
    }

    public void addAll(OptionsContainerBuilder container) {
        for (Map.Entry<Class<Option<?, ?>>, ValueContainerBuilder<?, ?>> entry : container.optionValues.entrySet()) {
            this.addAll(entry.getKey(), entry.getValue().build());
        }
    }

    public OptionsContainer build() {
        if (this.optionValues.isEmpty()) {
            return OptionsContainer.EMPTY;
        }
        HashMap<Class<Option<?, ?>>, ValueContainer<?, ?>> values = CollectionHelper.newHashMap(this.optionValues.size());
        for (Map.Entry<Class<Option<?, ?>>, ValueContainerBuilder<?, ?>> option : this.optionValues.entrySet()) {
            values.put(option.getKey(), option.getValue().build());
        }
        return new ImmutableOptionsContainer(values);
    }

    public String toString() {
        return "OptionsContainerBuilder [optionValues=" + this.optionValues + "]";
    }

    private <I, V> void addAll(Class<? extends Option<?, ?>> optionType, ValueContainer<?, ?> values) {
        ValueContainerBuilder<?, ?> valueContainer = this.getOrCreateValueContainer(optionType);
        valueContainer.addAll(values.getAll());
    }

    private <V, I> ValueContainerBuilder<I, V> getOrCreateValueContainer(Option<I, V> option) {
        Class<?> optionType = option.getClass();
        return this.getOrCreateValueContainer(optionType);
    }

    private <V, I> ValueContainerBuilder<I, V> getOrCreateValueContainer(Class<? extends Option<I, V>> optionType) {
        ValueContainerBuilder<I, V> values = this.getValueContainer(optionType);
        if (values == null) {
            values = this.createValueContainer(optionType);
            this.optionValues.put(optionType, values);
        }
        return values;
    }

    private <V, I> ValueContainerBuilder<I, V> getValueContainer(Class<? extends Option<I, V>> optionType) {
        ValueContainerBuilder<?, ?> values = this.optionValues.get(optionType);
        return values;
    }

    private <I, V> ValueContainerBuilder<I, V> createValueContainer(Class<? extends Option<I, V>> optionType) {
        if (UniqueOption.class.isAssignableFrom(optionType)) {
            return new UniqueValueContainerBuilder();
        }
        return new NonUniqueValueContainerBuilder();
    }

    private static class ImmutableOptionsContainer
    implements OptionsContainer {
        private final Map<Class<? extends Option<?, ?>>, ValueContainer<?, ?>> optionValues;

        public ImmutableOptionsContainer(Map<Class<? extends Option<?, ?>>, ValueContainer<?, ?>> optionValues) {
            this.optionValues = Collections.unmodifiableMap(optionValues);
        }

        @Override
        public <I, V> V get(Class<? extends Option<I, V>> optionType, I identifier) {
            ValueContainer<I, V> value = this.getValueContainer(optionType);
            return value != null ? (V)value.get(identifier) : null;
        }

        @Override
        public <V> V getUnique(Class<? extends UniqueOption<V>> optionType) {
            ValueContainer value = this.getValueContainer(optionType);
            return value != null ? (V)value.getUnique() : null;
        }

        @Override
        public <I, V, T extends Option<I, V>> Map<I, V> getAll(Class<T> optionType) {
            ValueContainer<I, V> value = this.getValueContainer(optionType);
            return value != null ? value.getAll() : Collections.emptyMap();
        }

        private <V, I> ValueContainer<I, V> getValueContainer(Class<? extends Option<I, V>> optionType) {
            ValueContainer<?, ?> values = this.optionValues.get(optionType);
            return values;
        }

        public String toString() {
            return "ImmutableOptionsContainer [optionValues=" + this.optionValues + "]";
        }
    }

    private static class NonUniqueValueContainerBuilder<I, V>
    implements ValueContainerBuilder<I, V> {
        private final Map<I, V> values = new HashMap<I, V>();

        private NonUniqueValueContainerBuilder() {
        }

        @Override
        public void add(I identifier, V value) {
            this.values.put(identifier, value);
        }

        @Override
        public void addAll(Map<I, V> values) {
            this.values.putAll(values);
        }

        @Override
        public ValueContainer<I, V> build() {
            return new NonUniqueValueContainer<I, V>(this.values);
        }
    }

    private static class UniqueValueContainerBuilder<I, V>
    implements ValueContainerBuilder<I, V> {
        private I identifier;
        private V value;

        private UniqueValueContainerBuilder() {
        }

        @Override
        public void add(I identifier, V value) {
            this.identifier = identifier;
            this.value = value;
        }

        @Override
        public void addAll(Map<I, V> values) {
            for (Map.Entry<I, V> entry : values.entrySet()) {
                this.identifier = entry.getKey();
                this.value = entry.getValue();
            }
        }

        @Override
        public ValueContainer<I, V> build() {
            return new UniqueValueContainer<I, V>(this.identifier, this.value);
        }
    }

    private static interface ValueContainerBuilder<I, V> {
        public void add(I var1, V var2);

        public void addAll(Map<I, V> var1);

        public ValueContainer<I, V> build();
    }

    private static class NonUniqueValueContainer<I, V>
    implements ValueContainer<I, V> {
        private final Map<I, V> values;

        public NonUniqueValueContainer(Map<I, V> values) {
            this.values = Collections.unmodifiableMap(values);
        }

        @Override
        public V get(I identifier) {
            return this.values.get(identifier);
        }

        @Override
        public V getUnique() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<I, V> getAll() {
            return this.values;
        }

        public String toString() {
            return "NonUniqueValueContainer [values=" + this.values + "]";
        }
    }

    private static class UniqueValueContainer<I, V>
    implements ValueContainer<I, V> {
        private final I identifier;
        private final V value;

        public UniqueValueContainer(I identifier, V value) {
            this.identifier = identifier;
            this.value = value;
        }

        @Override
        public V get(I identifier) {
            return this.value;
        }

        @Override
        public V getUnique() {
            return this.value;
        }

        @Override
        public Map<I, V> getAll() {
            return Collections.singletonMap(this.identifier, this.value);
        }

        public String toString() {
            return "UniqueValueContainer [identifier=" + this.identifier + ", value=" + this.value + "]";
        }
    }

    static interface ValueContainer<I, V> {
        public V get(I var1);

        public V getUnique();

        public Map<I, V> getAll();
    }
}

