/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.model.key.spi;

import java.util.Arrays;

public final class RowKey {
    private final String[] columnNames;
    private final Object[] columnValues;
    private final int hashCode;

    public RowKey(String[] columnNames, Object[] columnValues) {
        this.columnNames = columnNames;
        this.columnValues = columnValues;
        this.hashCode = this.generateHashCode();
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public Object[] getColumnValues() {
        return this.columnValues;
    }

    public Object getColumnValue(String columnName) {
        for (int j = 0; j < this.columnNames.length; ++j) {
            if (!this.columnNames[j].equals(columnName)) continue;
            return this.columnValues[j];
        }
        return null;
    }

    public boolean contains(String column) {
        for (String columnName : this.columnNames) {
            if (!columnName.equals(column)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || RowKey.class != o.getClass()) {
            return false;
        }
        RowKey that = (RowKey)o;
        if (!Arrays.equals(this.columnValues, that.columnValues)) {
            return false;
        }
        return Arrays.equals(this.columnNames, that.columnNames);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generateHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.columnNames);
        result = 31 * result + Arrays.hashCode(this.columnValues);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RowKey[");
        int i = 0;
        for (String column : this.columnNames) {
            sb.append(column).append("=").append(this.columnValues[i]);
            if (++i >= this.columnNames.length) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

