/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.model.impl;

import java.util.Arrays;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;

public class DefaultAssociatedEntityKeyMetadata
implements AssociatedEntityKeyMetadata {
    private final String[] associationKeyColumns;
    private final EntityKeyMetadata entityKeyMetadata;

    public DefaultAssociatedEntityKeyMetadata(String[] associationKeyColumns, EntityKeyMetadata entityKeyMetadata) {
        this.associationKeyColumns = associationKeyColumns;
        this.entityKeyMetadata = entityKeyMetadata;
    }

    @Override
    public EntityKeyMetadata getEntityKeyMetadata() {
        return this.entityKeyMetadata;
    }

    @Override
    public String getCorrespondingEntityKeyColumn(String associationKeyColumn) {
        int i = 0;
        for (String column : this.associationKeyColumns) {
            if (associationKeyColumn.equals(column)) {
                return this.entityKeyMetadata.getColumnNames()[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public String[] getAssociationKeyColumns() {
        return this.associationKeyColumns;
    }

    public String toString() {
        return "DefaultAssociatedEntityKeyMetadata [associationKeyColumns=" + Arrays.toString(this.associationKeyColumns) + ", entityKeyMetadata=" + this.entityKeyMetadata + "]";
    }
}

