/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.id.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.ExportableProducer;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.ogm.dialect.impl.GridDialects;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.id.impl.OgmGeneratorBase;
import org.hibernate.ogm.id.impl.OgmTableGenerator;
import org.hibernate.ogm.model.impl.DefaultIdSourceKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class OgmSequenceGenerator
extends OgmGeneratorBase
implements ExportableProducer {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private Type type;
    private Properties params;
    private QualifiedName logicalQualifiedSequenceName;
    private String sequenceName;
    private IdSourceKeyMetadata generatorKeyMetadata;
    private IdSourceKeyAndKeyMetadataProvider delegate;

    @Override
    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        super.configure(type, params, serviceRegistry);
        JdbcEnvironment jdbcEnvironment = (JdbcEnvironment)serviceRegistry.getService(JdbcEnvironment.class);
        this.type = type;
        this.params = params;
        this.logicalQualifiedSequenceName = this.determineSequenceName(params, jdbcEnvironment);
        this.sequenceName = jdbcEnvironment.getQualifiedObjectNameFormatter().format(this.logicalQualifiedSequenceName, jdbcEnvironment.getDialect());
        this.generatorKeyMetadata = DefaultIdSourceKeyMetadata.forSequence(this.sequenceName);
        this.delegate = this.getDelegate(serviceRegistry);
    }

    @Override
    public IdSourceKeyMetadata getGeneratorKeyMetadata() {
        return this.delegate.getGeneratorKeyMetadata();
    }

    @Override
    protected IdSourceKey getGeneratorKey(SessionImplementor session) {
        return this.delegate.getGeneratorKey(session);
    }

    protected QualifiedName determineSequenceName(Properties params, JdbcEnvironment jdbcEnv) {
        String catalogName;
        String sequencePerEntitySuffix = ConfigurationHelper.getString((String)"sequence_per_entity_suffix", (Map)params, (String)"_SEQ");
        String defaultSequenceName = ConfigurationHelper.getBoolean((String)"prefer_sequence_per_entity", (Map)params, (boolean)false) ? params.getProperty("jpa_entity_name") + sequencePerEntitySuffix : "hibernate_sequence";
        String sequenceName = ConfigurationHelper.getString((String)"sequence_name", (Map)params, (String)defaultSequenceName);
        if (sequenceName.contains(".")) {
            return QualifiedNameParser.INSTANCE.parse(sequenceName);
        }
        String schemaName = params.getProperty("schema");
        if (schemaName != null) {
            log.schemaOptionNotSupportedForSequenceGenerator(schemaName);
        }
        if ((catalogName = params.getProperty("catalog")) != null) {
            log.catalogOptionNotSupportedForSequenceGenerator(catalogName);
        }
        return new QualifiedNameParser.NameParts(null, null, jdbcEnv.getIdentifierHelper().toIdentifier(sequenceName));
    }

    private IdSourceKeyAndKeyMetadataProvider getDelegate(ServiceRegistry serviceRegistry) {
        GridDialect gridDialect = super.getGridDialect();
        if (gridDialect.supportsSequences()) {
            return new SequenceKeyAndMetadataProvider(this.generatorKeyMetadata);
        }
        log.dialectDoesNotSupportSequences(GridDialects.getWrappedDialect(gridDialect), (String)this.params.get("jpa_entity_name"));
        OgmTableGenerator tableGenerator = new OgmTableGenerator();
        Properties newParams = new Properties();
        newParams.putAll((Map<?, ?>)this.params);
        newParams.put("segment_value", this.sequenceName);
        tableGenerator.configure(this.type, newParams, serviceRegistry);
        return new TableKeyAndMetadataProvider(tableGenerator);
    }

    public void registerExportables(Database database) {
        Namespace namespace = database.locateNamespace(this.logicalQualifiedSequenceName.getCatalogName(), this.logicalQualifiedSequenceName.getSchemaName());
        Sequence sequence = namespace.locateSequence(this.logicalQualifiedSequenceName.getObjectName());
        if (sequence != null) {
            sequence.validate(this.getInitialValue(), this.getIncrementSize());
        } else {
            sequence = namespace.createSequence(this.logicalQualifiedSequenceName.getObjectName(), this.getInitialValue(), this.getIncrementSize());
        }
    }

    private static class SequenceKeyAndMetadataProvider
    implements IdSourceKeyAndKeyMetadataProvider {
        private final IdSourceKey idSourceKey;

        private SequenceKeyAndMetadataProvider(IdSourceKeyMetadata idSourceKeyMetadata) {
            this.idSourceKey = IdSourceKey.forSequence(idSourceKeyMetadata);
        }

        @Override
        public IdSourceKeyMetadata getGeneratorKeyMetadata() {
            return this.idSourceKey.getMetadata();
        }

        @Override
        public IdSourceKey getGeneratorKey(SessionImplementor session) {
            return this.idSourceKey;
        }
    }

    private static class TableKeyAndMetadataProvider
    implements IdSourceKeyAndKeyMetadataProvider {
        private final OgmTableGenerator delegate;

        public TableKeyAndMetadataProvider(OgmTableGenerator delegate) {
            this.delegate = delegate;
        }

        @Override
        public IdSourceKeyMetadata getGeneratorKeyMetadata() {
            return this.delegate.getGeneratorKeyMetadata();
        }

        @Override
        public IdSourceKey getGeneratorKey(SessionImplementor session) {
            return this.delegate.getGeneratorKey(session);
        }
    }

    private static interface IdSourceKeyAndKeyMetadataProvider {
        public IdSourceKeyMetadata getGeneratorKeyMetadata();

        public IdSourceKey getGeneratorKey(SessionImplementor var1);
    }
}

