/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.eventstate.impl;

import org.hibernate.HibernateException;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.ogm.dialect.eventstate.impl.EventContextManager;

public class EventContextManagingFlushEventListener
implements FlushEventListener {
    private FlushEventListener delegate;
    private final EventContextManager stateManager;

    public EventContextManagingFlushEventListener(EventContextManager stateManager) {
        this.stateManager = stateManager;
    }

    public void setDelegate(FlushEventListener delegate) {
        this.delegate = delegate;
    }

    public void onFlush(FlushEvent event) throws HibernateException {
        this.stateManager.onEventBegin(event.getSession());
        try {
            this.delegate.onFlush(event);
        }
        finally {
            this.stateManager.onEventFinished();
        }
    }

    public static class EventContextManagingFlushEventListenerDuplicationStrategy
    implements DuplicationStrategy {
        public static final DuplicationStrategy INSTANCE = new EventContextManagingFlushEventListenerDuplicationStrategy();

        private EventContextManagingFlushEventListenerDuplicationStrategy() {
        }

        public boolean areMatch(Object listener, Object original) {
            if (listener instanceof EventContextManagingFlushEventListener && original instanceof FlushEventListener) {
                ((EventContextManagingFlushEventListener)listener).setDelegate((FlushEventListener)original);
                return true;
            }
            return false;
        }

        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.REPLACE_ORIGINAL;
        }
    }
}

