/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.map.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.datastore.map.impl.MapDatastoreProvider;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.model.impl.EntityKeyBuilder;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.persister.entity.Lockable;

public class MapPessimisticWriteLockingStrategy
implements LockingStrategy {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    protected final Lockable lockable;
    protected final LockMode lockMode;
    protected final GridType identifierGridType;
    private volatile MapDatastoreProvider provider;

    public MapPessimisticWriteLockingStrategy(Lockable lockable, LockMode lockMode) {
        this.lockable = lockable;
        this.lockMode = lockMode;
        TypeTranslator typeTranslator = (TypeTranslator)lockable.getFactory().getServiceRegistry().getService(TypeTranslator.class);
        this.identifierGridType = typeTranslator.getType(lockable.getIdentifierType());
    }

    public void lock(Serializable id, Object version, Object object, int timeout, SessionImplementor session) throws StaleObjectStateException, JDBCException {
        MapDatastoreProvider dataStore = this.getProvider(session);
        EntityKey key = EntityKeyBuilder.fromData(((OgmEntityPersister)this.lockable).getRootEntityKeyMetadata(), this.identifierGridType, id, session);
        dataStore.writeLock(key, timeout);
    }

    protected final MapDatastoreProvider getProvider(SessionImplementor session) {
        if (this.provider == null) {
            DatastoreProvider service = (DatastoreProvider)session.getFactory().getServiceRegistry().getService(DatastoreProvider.class);
            if (service instanceof MapDatastoreProvider) {
                this.provider = (MapDatastoreProvider)service;
            } else {
                log.unexpectedDatastoreProvider(service.getClass(), MapDatastoreProvider.class);
            }
        }
        return this.provider;
    }
}

