/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.cfg.impl;

import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.ogm.massindex.impl.OgmMassIndexerFactory;
import org.hibernate.search.query.DatabaseRetrievalMethod;

public final class HibernateSearchIntegration {
    private static final boolean searchIsAvailable = HibernateSearchIntegration.isSearchAvailable();
    private static String MASSINDEXER_PROPERTY_KEY = null;
    private static String MASSINDEXER_PROPERTY_VALUE = null;
    private static String RETRIEVALSTRATEGY_PROPERTY_KEY = null;
    private static String RETRIEVALSTRATEGY_PROPERTY_VALUE = null;

    private HibernateSearchIntegration() {
    }

    private static boolean isSearchAvailable() {
        try {
            HibernateSearchIntegration.class.getClassLoader().loadClass("org.hibernate.search.cfg.Environment");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void resetProperties(StandardServiceRegistryBuilder registryBuilder) {
        if (searchIsAvailable) {
            registryBuilder.applySetting(MASSINDEXER_PROPERTY_KEY, (Object)MASSINDEXER_PROPERTY_VALUE);
            registryBuilder.applySetting(RETRIEVALSTRATEGY_PROPERTY_KEY, (Object)RETRIEVALSTRATEGY_PROPERTY_VALUE);
        }
    }

    static {
        if (searchIsAvailable) {
            RETRIEVALSTRATEGY_PROPERTY_KEY = "hibernate.search.query.database_retrieval_method";
            RETRIEVALSTRATEGY_PROPERTY_VALUE = DatabaseRetrievalMethod.FIND_BY_ID.name();
            MASSINDEXER_PROPERTY_KEY = "hibernate.search.massindexer.factoryclass";
            MASSINDEXER_PROPERTY_VALUE = OgmMassIndexerFactory.class.getName();
        }
    }
}

