/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.infinispan.counter.api.CounterState;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.exception.CounterException;
import org.infinispan.functional.Param;

public final class Utils {
    private Utils() {
    }

    public static boolean isValid(long lowerBound, long value, long upperBound) {
        return lowerBound > value || value > upperBound;
    }

    public static CounterState calculateState(long value, long lowerBound, long upperBound) {
        if (value < lowerBound) {
            return CounterState.LOWER_BOUND_REACHED;
        }
        if (value > upperBound) {
            return CounterState.UPPER_BOUND_REACHED;
        }
        return CounterState.VALID;
    }

    public static CounterException rethrowAsCounterException(Throwable throwable) {
        if (throwable instanceof CounterException) {
            return (CounterException)throwable;
        }
        if (throwable instanceof ExecutionException || throwable instanceof CompletionException) {
            return Utils.rethrowAsCounterException(throwable.getCause());
        }
        return new CounterException(throwable);
    }

    public static <T> T awaitCounterOperation(CompletableFuture<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Utils.rethrowAsCounterException(e);
        }
        catch (ExecutionException e) {
            throw Utils.rethrowAsCounterException(e);
        }
    }

    public static Param.PersistenceMode getPersistenceMode(Storage storage) {
        switch (storage) {
            case PERSISTENT: {
                return Param.PersistenceMode.PERSIST;
            }
            case VOLATILE: {
                return Param.PersistenceMode.SKIP;
            }
        }
        throw new IllegalStateException("[should never happen] unknown storage " + storage);
    }
}

